#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#

package SDB::Install::SysVars;
use strict;
use SDB::Install::Version;
use SDB::Install::LoadSysInfoExtension;
use Config;

our $sysinfo = SAPDB::Install::SysInfo::GetSystemInfo ();

use strict;

use Exporter;

our @ISA = qw (Exporter);

our @EXPORT = qw ($path_separator $env_path_separator $re_path_separator
    $isWin $isLinux $isApple $installerPlatformName $installerIs64bit
    $currentPlatformName $compatiblePlatformNames $isPowerPC $isPPC64 $isPPC64LE);

our $isWin = $^O =~ /mswin/i;

our $isLinux = $^O =~ /linux/i;

our $isApple = $^O =~ /darwin/i;

our $isPowerPC = $Config{archname} =~ /ppc/i;

# little endian ppc64
our $isPPC64LE = $Config{archname} =~ /ppc64le/i;

# big endian ppc64
our $isPPC64 = ($Config{archname} =~ /ppc64/i) && !$isPPC64LE;

our $path_separator;

if ($isWin){
	$path_separator = '\\';
	our $env_path_separator = ';';

}
else{
	$path_separator = '/';
	our $env_path_separator = ':';
}

our $re_path_separator = quotemeta ($path_separator);

# $Config{archname}                $MACHINE_CONFIG
# i686-linux-thread-multi          linuxintel
# i86pc-solaris-thread-multi-64    sunx86_64
# IA64.ARCHREV_0-thread-multi-LP64 hpia64
# aix-thread-multi-64all           rs6000_64
# sun4-solaris-thread-multi-64     sun_64
# MSWin32-x86 -multi-thread        NTintel
# MSWin32-AMD64-multi-thread       NTamd64
# x86_64-linux-thread-multi        linuxx86_64
# s390x-linux-thread-multi         linuxs390x

our $perlArchName = $Config{archname};
$perlArchName =~ s/^([^-]+-[^-]+)-.+/$1/;

our $perlArchnameToManifestPlatform = {
	'i686-linux'            => {'platform' => 'linuxintel',   'bit64' => 0 },
	'i86pc-solaris'         => {'platform' => 'sunx86_64',    'bit64' => 1 },
	'IA64.ARCHREV_0-thread' => {'platform' => 'hpia64',       'bit64' => 1 },
	'aix-thread'            => {'platform' => 'rs6000_64',    'bit64' => 1 },
	'sun4-solaris'          => {'platform' => 'sun_64',       'bit64' => 1 },
	'MSWin32-x86'           => {'platform' => 'NTintel',      'bit64' => 0 },
	'MSWin32-AMD64'         => {'platform' => 'NTamd64',      'bit64' => 1 },
	'x86_64-linux'          => {'platform' => 'linuxx86_64',  'bit64' => 1 },
	's390x-linux'           => {'platform' => 'linuxs390x',   'bit64' => 1 },
	'MSWin32-x64'           => {'platform' => 'NTamd64',      'bit64' => 1 },
	'x86_64-linux'          => {'platform' => 'linuxx86_64' , 'bit64' => 1 },
	'darwin-thread'         => {'platform' => 'darwinintel64', 'bit64' => 1 },
        'ppc64-linux'           => {'platform' => 'linuxppc64',   'bit64' => 1 },
        'ppc64le-linux'         => {'platform' => 'linuxppc64le', 'bit64' => 1 },
};


our $sysinfoArchnameToManifestPlatform = {
    'AIX' => {
            'PowerPC'   =>      {'platform' => 'rs6000_64'}
     },
    'OS400' => {
            'PowerPC'   =>      {'platform' => 'rs6000_64'}
     },
    'HPUX' => {
            'IA64'      =>      {'platform' => 'hpia64'},
            'PA-RISC'   =>      {'platform' => 'hp_64'}
     },
    'Linux' => {
            'I386'      =>      {'platform' => 'linuxintel',
                                'compat_platforms' => [
                                    'linuxintel_sles9'
                                ]},
            'X86-64'    =>      {'platform' => 'linuxx86_64',
                                'compat_platforms' => [
                                    'linuxx86_64_sles9',
                                    'linuxintel',
                                    'linuxintel_sles9'
                                ]},
            'IA64'      =>      {'platform' => 'linuxia64'},
            'PPC64LE'   =>      {'platform' => 'linuxppc64le'},
            'PPC'       =>      {'platform' => 'linuxppc64'},
            'S390'      =>      {'platform' => 'linuxs390x'}
     },
    'Tru64' => {
            'ALPHA'     =>      {'platform' => 'aplhaosf'},
     },
    'Solaris' => {
        'SPARC'         =>      {'platform' => 'sun_64'},
            'X86-64'    =>      {'platform' => 'sunx86_64'},
     },
    'Reliant' => {
            'MIPS'      =>      {'platform' => 'reliant'}
     },
    'Mac OS X' => {
            'X86-64'    =>      {'platform' => 'macosx'},
            'PPC'       =>      {'platform' => 'macpower'}
     },
     'Windows' => {
            'I386'      =>      {'platform' => 'NTintel'},
            'AMD64'    =>      {'platform' => 'NTamd64',
                                'compat_platforms' => [
                                    'NTintel'
                                 ]}
     }
};


our $currentPlatformName =
    $sysinfoArchnameToManifestPlatform->{$sysinfo->{system}}->{$sysinfo->{architecture}}->{platform};

our $compatiblePlatformNames =
    $sysinfoArchnameToManifestPlatform->{$sysinfo->{system}}->{$sysinfo->{architecture}}->{compat_platforms};


if ($sysinfo->{system} eq 'Linux' && $sysinfo->{architecture} eq 'X86-64'){
    #
    # if glibc < 2.9 => use SLES9 make assemblies
    #
    my ($version) = ($sysinfo->{c_runtime} =~ /GLIBC\s+([\d\.]+)/);
    if (defined $version){
        my $glibcversion = new SDB::Install::Version (split ('\.', $version));
        if (!$glibcversion->isNewerThan(new SDB::Install::Version (2,8,9))){
            $currentPlatformName = 'linuxx86_64_sles9';
            $compatiblePlatformNames = ['linuxintel_sles9'];
        }
    }
}

$sysinfo = undef;

our $installerPlatformName = $perlArchnameToManifestPlatform->{$perlArchName}->{'platform'};
our $installerIs64bit      = $perlArchnameToManifestPlatform->{$perlArchName}->{'bit64'};


sub new{
    return bless ({}, shift);
}

sub isWin{
    return $isWin;
}

1;
