package SDB::Install::System::EnvVariable;

use base SDB::Install::BaseLegacy;
use SDB::Install::System qw (isSameFile2 getFileId);
use SAPDB::Install::System::Win32::Registry;
use SAPDB::Install::System::Win32::API;
use SDB::Install::SysVars qw ($isWin);

our $sysEnvKey = 'SYSTEM\CurrentControlSet\Control\Session Manager\Environment';
our $userEnvKey = 'Environment';

sub new {
	my ($class, $name, $data) = @_;
	my %copy = %$data;
	my $self = bless (\%copy, $class);
	$self->{name} = $name;
	return $self;
}


sub isPathInValue{
    my ($value,$separator, $path) = @_;
    my $fileId = getFileId (\$path);
    foreach my $entry (split($separator,$value)){
        if (isSameFile2 ($entry,undef,$fileId)){
            return 1;
        }
    }
    return 0;
}

sub set{
	my ($self) = @_;

	if (!$isWin) {
		$self->AddMessage("Permanent setting of environment variables is not implemented on Linux.");
		return 1;
	}

	my $hKeyRoot;
	my $keyName;
	my $keyRoot;
	if ($self->{EnvVarType} eq 'SYSTEM'){
		$hKeyRoot = HKEY_LOCAL_MACHINE;
		$keyRoot = 'HKEY_LOCAL_MACHINE';
		$keyName  = $sysEnvKey;
	}
	else{
		$hKeyRoot = HKEY_CURRENT_USER;
		$keyRoot = 'HKEY_CURRENT_USER';
		$keyName  = $userEnvKey;
	}
	my $errlst = new SDB::Install::MsgLst();

	my $hKey;

	if (RegOpenKeyEx ($hKeyRoot, $keyName, 0, &KEY_SET_VALUE | &KEY_READ, $hKey) != 0){
		$self->AddError ("Cannot open registry key '$keyRoot\\$keyname': $!");
		return undef;
	}

	my $i=0;
	my ($ValCount, $index, $sValName, $piType, $pValData);

	my $name = $self->{name};
	my $pattern = '^' . quotemeta ($name) . '$';
	my ($recent_value, $recent_type, $recent_session_name, $recent_session_value);

	my $msg = $self->AddMessage ("Setting variable '$name' in current environment");

	if ($self->{SetForCurrentSession}){

		#
		#  set variable in current session
		#

		$recent_session_name = $self->{name};
		foreach my $envvar (keys (%ENV)){
			if (lc ($envvar) eq lc ($self->{name})){
				$recent_session_name = $envvar;
				$self->AddSubMessage ($msg, "Variable already exists, value = " . $ENV{$envvar});
				last;
			}
		}

		$recent_session_value = $ENV{$recent_session_name};

		my $value;
		if ($self->{EnvVarExtend} eq 'Prefix'){
			$value = $self->{EnvVarValue} . ($recent_session_value ? ($self->{EnvVarSeparator} . $recent_session_value) : '' );
		}
		elsif ($self->{EnvVarExtend} eq 'Postfix'){
			$value = ($recent_session_value ? ($recent_session_value) . $self->{EnvVarSeparator} : '' ) . $self->{EnvVarValue};
		}
		else{
			$value = $self->{EnvVarValue};
		}
		$self->AddSubMessage ($msg, "Setting variable to  " . $value);
		$ENV{$recent_session_name} = $value;
	}

	#
	#  set variable in registry
	#


	$msg = $self->AddMessage ("Setting variable '$self->{name}' in $self->{EnvVarType} environment");

	$recent_type = &REG_SZ;

	RegQueryInfoKey ($hKey, 0, 0, 0, 0, 0, 0, $ValCount, 0, 0, 0, 0);
	for ($index = 0; $index < $ValCount; $index++){
		RegEnumValue( $hKey, $index ,$sValName, 0, 0, $piType, $pValData, 0 );
		if(Win32::GetLastError()==259){last;}
		if($piType==&REG_BINARY){
			$pValData=unpack("H*",$pValData);
		}
		elsif($piType==&REG_EXPAND_SZ and not $notexpand){
			ExpandEnvironmentStrings($pValData,$pValData,0);
		}
		$sValName = '(Default)' unless $sValName =~ /\S/;
		if ($sValName =~ /$pattern/i){
			$self->AddSubMessage ($msg, "Variable already exists, value = $pValData");
			$name = $sValName;
			$recent_value = $pValData;
			$recent_type = $piType;
			last;
		}
	}

    if ($recent_value && -e $self->{EnvVarValue} && isPathInValue ($recent_value, $self->{EnvVarSeparator}, $self->{EnvVarValue})){
        $self->AddSubMessage ($msg, "Path '$self->{EnvVarValue}' is already in variable '$self->{name}'");
        RegCloseKey ($hKey);
        return 1;
    }
    my $value;
	if ($self->{EnvVarExtend} eq 'Prefix'){
		$value = $self->{EnvVarValue} . ($recent_value ? ($self->{EnvVarSeparator} . $recent_value) : '' );
	}
	elsif ($self->{EnvVarExtend} eq 'Postfix'){
		$value = ($recent_value ? ($recent_value) . $self->{EnvVarSeparator} : '' ) . $self->{EnvVarValue};
	}
	else{
		$value = $self->{EnvVarValue};
	}

	$self->AddSubMessage ($msg, "Setting variable to  " . $value);

	if (RegSetValueEx ($hKey, $name, 0, $recent_type, $value, 0) != 0){
		$self->AddError ("Cannot set registry value '$name' of key $keyRoot\\$keyname: $!");
		RegCloseKey ($hKey);
		return undef;
	}

	RegCloseKey ($hKey);
	return 1;
}


sub unset{
    my ($self) = @_;

	if (!$isWin) {
		$self->AddMessage("Permanent unsetting of environment variables is not implemented on Linux.");
		return 1;
	}

    my $hKeyRoot;
    my $keyName;
    my $keyRoot;
    if ($self->{EnvVarType} eq 'SYSTEM'){
        $hKeyRoot = HKEY_LOCAL_MACHINE;
        $keyRoot = 'HKEY_LOCAL_MACHINE';
        $keyName  = $sysEnvKey;
    }
    else{
        $hKeyRoot = HKEY_CURRENT_USER;
        $keyRoot = 'HKEY_CURRENT_USER';
        $keyName  = $userEnvKey;
    }
    my $errlst = new SDB::Install::MsgLst();

    my $hKey;

    if (RegOpenKeyEx ($hKeyRoot, $keyName, 0, &KEY_SET_VALUE | &KEY_READ, $hKey) != 0){
        $self->AddError ("Cannot open registry key '$keyRoot\\$keyname': $!");
        return undef;
    }

    my $i=0;
    my ($ValCount, $index, $sValName, $piType, $pValData);

    my $name = $self->{name};
    my $pattern = '^' . quotemeta ($name) . '$';
    my ($recent_value, $recent_type, $recent_session_name, $recent_session_value);

    #
    #  cleaning variable in registry
    #

    $msg = $self->AddMessage ("Cleaning variable '$self->{name}' in $self->{EnvVarType} environment");

    $recent_type = &REG_SZ;

    RegQueryInfoKey ($hKey, 0, 0, 0, 0, 0, 0, $ValCount, 0, 0, 0, 0);
    for ($index = 0; $index < $ValCount; $index++){
        RegEnumValue( $hKey, $index ,$sValName, 0, 0, $piType, $pValData, 0 );
        if(Win32::GetLastError()==259){last;}
        if($piType==&REG_BINARY){
            $pValData=unpack("H*",$pValData);
        }
        elsif($piType==&REG_EXPAND_SZ and not $notexpand){
            ExpandEnvironmentStrings($pValData,$pValData,0);
        }
        $sValName = '(Default)' unless $sValName =~ /\S/;
        if ($sValName =~ /$pattern/i){
            $self->AddSubMessage ($msg, "Variable exists, value = $pValData");
            $name = $sValName;
            $recent_value = $pValData;
            $recent_type = $piType;
            last;
        }
    }

    if (!$recent_type){
        $self->AddSubMessage ($msg, "Variable is already gone.");
        RegCloseKey ($hKey);
        return 1;
    }

    if ($self->{EnvVarExtend} eq 'No'){
        # just delete
        $self->AddSubMessage ($msg, "Removing variable");
        if (RegDeleteValue ($hKey, $name) != 0){
            $self->AddSubMessage ($msg, "Cannot delete registry value '$name' of key '$keyRoot\\$keyName': $!");
        }
        RegCloseKey ($hKey);
        return 1;
    }

	my @pattern_list;
	foreach my $entry (split ($self->{EnvVarSeparator}, $self->{EnvVarValue})){
		push @pattern_list, '^' . quotemeta ($entry) . '$';
	}

    $pattern = join ('|' , @pattern_list);

    my @new_value;
    my $found = 0;
    foreach my $part (split ($self->{EnvVarSeparator}, $recent_value)){
        if ($part =~ /$pattern/i){
            $found = 1;
            next;
        }
        push  @new_value, $part;
    }

    if (!$found){
        $self->AddSubMessage ($msg, "Variable is already cleaned.");
        RegCloseKey ($hKey);
        return 1;
    }

    my $value = join ($self->{EnvVarSeparator}, @new_value);

    $self->AddSubMessage ($msg, "Setting variable to  " . $value);

    if (RegSetValueEx ($hKey, $name, 0, $recent_type, $value, 0) != 0){
        $self->AddError ("Cannot set registry value '$name' of key $keyRoot\\$keyname: $!");
        RegCloseKey ($hKey);
        return undef;
    }
    RegCloseKey ($hKey);
    return 1;

}

1;