package SDB::Install::System::Mounts;

use strict;
use base 'SDB::Install::Base';
use IO::File;

our $mountsFileName = '/proc/self/mounts';

sub readMounts{
    my ($self, $nocache) = @_;
    $nocache = $nocache // 0;
    if (defined $self->{mounts} && !$nocache){
        return $self->{mounts};
    }

    my $mountsFile = new IO::File();
    if (!$mountsFile->open($mountsFileName)){
        $self->setErrorMessage ("Cannot open file '$mountsFileName': $!");
        return undef;
    }

    my @mounts;
    while (my $line = $mountsFile->getline()){
        chomp $line;
        my %mntent;
        ($mntent{mnt_fsname},
         $mntent{mnt_dir},
         $mntent{mnt_type},
         $mntent{mnt_opts},
         $mntent{mnt_freq},
         $mntent{mnt_passno}) = split (/\s+/, $line);

        push @mounts, \%mntent;
    }
    if ($mountsFile->error()){
        $self->setErrorMessage ("Cannot read file '$mountsFileName': $!");
        return undef;
    }
    $self->{mounts} = \@mounts;
    return $self->{mounts};
}


sub getMountsWithType{
    my ($self, $type, $mounts, $nocache) = @_;
    if (!defined $mounts){
        $mounts = $self->readMounts($nocache);
    }
    if (!defined $mounts){
        return undef;
    }
    my @mountsWithType;
    foreach my $mntent (@$mounts){
        if ($mntent->{mnt_type} eq $type){
            push @mountsWithType, $mntent;
        }
    }
    return \@mountsWithType;
}

sub getMountsWithOption{
    my ($self, $option, $mounts, $nocache) = @_;
    if (!defined $mounts){
        $mounts = $self->readMounts($nocache);
    }
    if (!defined $mounts){
        return undef;
    }
    my @mountsWithOption;
    foreach my $mntent (@$mounts){
        my @options = split (',', $mntent->{mnt_opts});
        if (!grep {$_ eq $option} @options){
            next;
        }
        push @mountsWithOption, $mntent;
    }
    return \@mountsWithOption;
}

sub getNVMMounts{
    my ($self, $nocache) = @_;
    return $self->getMountsWithOption ('dax', undef, $nocache);
}

sub getTmpfsMounts{
    my ($self, $nocache) = @_;
    return $self->getMountsWithType ('tmpfs', undef, $nocache);
}

1;
