package SDB::Install::System::Trashcan;

#
# module to handle busy files on HP-UX
#

use base SDB::Install::BaseLegacy;
use SAPDB::Install::FSUsage;
use strict;

our $trashcan_folder = '.hdb_deleted_files';

our $trashcan;

our %file_systems;


sub getTrashcan {
    if (!defined $trashcan){
        $trashcan = new SDB::Install::System::Trashcan ();
    }
    return $trashcan;
}


sub find_vacant_name{
    my ($list, $name) = @_;
    my $found;
    my $vacantname = $name;
    my $i = 0;
    while (1){
        $found = 0;
        foreach my $entry (@$list){
            if ($entry eq $vacantname){
                $found = 1;
                last;
            }
        }
        if (!$found){
            return $vacantname;
        }
        $vacantname = sprintf ("$name%d",$i++);
    }
}

sub dropFile{
    my ($self, $file) = @_;
    my $first = 0;
    my @statbuf = stat ($file);
    if (!@statbuf){
        $self->AddError ("Cannot stat file '$file' : $!");
        return undef;
    }
    if (!-f _){
        $self->AddError ("'$file' is no regular file");
        return undef;
    }

    my $mountPoint;
    if (exists $file_systems{$statbuf[0]}){
        $mountPoint = $file_systems{$statbuf[0]}->[0];
    }
    else{
        $mountPoint = GetFSName ($file);
        if (!defined $mountPoint){
            $self->AddError ("Cannot get mount point of '$file'");
            return undef;
        }
        $first = 1;
        $file_systems{$statbuf[0]} = [$mountPoint];
    }
    if ($first){
        if (!defined $self->initMountPoint ($file_systems{$statbuf[0]})){
            $self->AddErrror ("Cannot initialize trashcan for fs '$mountPoint'", $self);
            return undef;
        }
    }
    my $mp = $file_systems{$statbuf[0]};
    my ($basename) = ($file =~ /([^\/]+$)/);
    my $vacantname = find_vacant_name ($mp->[1], $basename);
    my $trashFolder = $mp->[0] . '/' . $trashcan_folder;
    if (!rename ($file,$trashFolder . '/' . $vacantname)){
        $self->AddError ("Cannot mv file '$file' => '$trashFolder/$vacantname': $!");
        return undef;
    }
    push @{$mp->[1]}, $vacantname;
    return 1;
}

sub initMountPoint{
    my ($self,$mp) = @_;
    my $trashFolder = $mp->[0] . '/' . $trashcan_folder;
    if (!-e ($trashFolder)){
        if (!mkdir ($trashFolder)){
            $self->AddError ("Cannot create directory '$trashFolder': $!");
            return undef;
        }
        chown 0777, $trashFolder;
        $mp->[1] = []; # trashcan content is empty
    }
    elsif (-d _){
        if (!opendir (DH,$trashFolder)){
            $self->AddError ("Cannot open directory '$trashFolder': $!");
            return undef;
        }
        $mp->[1] = [grep {!/^\.{1,2}$/} readdir (DH)];
        closedir (DH);
        $self->clean ($mp);
    }
    else{
        $self->AddError ("'$trashFolder' has to be a directory");
        return undef;
    }
    return 1;
}

sub clean {
    my ($self, $mp) = @_;
    if (defined $mp){
        my $trashFolder = $mp->[0] . '/' . $trashcan_folder;
        my @listCopy;
        my $fullPath;
        foreach my $file (@{$mp->[1]}){
            $fullPath = $trashFolder . '/' . $file;
            if (-f $trashFolder . '/' . $file){
                if (unlink ($fullPath)){
                    next;
                }
                push @listCopy, $file;
            }
        }
        $mp->[1] = \@listCopy;
    }
    else{
        foreach my $mp (values %file_systems){
            $self->clean ($mp);
        }
    }
    return 1;
}

1;
