#!/usr/bin/perl
#
# $Header$
# $DateTime$
# $Change$
#

package SDB::Install::XMLParser;

use base XML::Parser::Expat;
use MIME::Base64;
use warnings;
use strict;
use SDB::Common::BuiltIn;


sub new {
	my $self = shift->SUPER::new (@_);
	$self->{root} = undef;
	$self->{parent} = undef;
	$self->{current} = undef;
	$self->setHandlers (
		'Start' => \&sh,
		'End'   => \&eh,
		'Char'  => \&ch);
	return $self;
}



sub sh{
	my ($self, $el, %atts) = @_;
	my $cur = $self->{current} = {'type' => $el, 'attr' => \%atts};
	
	if (defined $self->{parent}){
		$cur->{parent} = $self->{parent};
	}
	else{
		$self->{root} = $cur;
	}
	$self->{parent} = $cur;
}

sub eh{
	my ($self, $el) = @_;
	my $cur = $self->{current};
	if (defined $cur->{parent}){
		if (! defined $cur->{parent}->{child}) {
			$cur->{parent}->{child} = $cur;
		}
		else{
			my $element = $cur->{parent}->{child};
			while (defined $element->{neighbor}) {
				$element = $element->{neighbor};
			}
			$element->{neighbor} = $cur;
		}
	}
	$self->{current} = $self->{parent} = $cur->{parent};
}

sub ch{
	my ($self, $cn) = @_;
	my $node = $self->{current};
	my $attr = $node->{attr} // {};
	if (defined $attr->{encoding} && $attr->{encoding} eq 'base64'){
		$cn = decode_base64 ($cn);
	}
	if (defined $node->{content}){
		$node->{content} .= $cn;
	}
	else{
		$node->{content} = $cn;
	}
}

sub printTree{
	my ($self,$node, $indent) = @_;
	if (!defined $node){
		$node = $self->{root};
	}
	
	if (!defined $node){
		return;
	}
	$indent //= '';
	SDB::Common::BuiltIn->get_instance()->print("$indent$node->{type}" .
		( $node->{content} ? " = $node->{content}" : '') . "\n");

	if (defined $node->{child}){
		$self->printTree ($node->{child}, $indent . "  ");
	}

	if (defined $node->{neighbor}){
		$self->printTree ($node->{neighbor}, $indent);
	}
}

sub getElementByTagName {
	my ($self, $tag, $node) = @_;
    my $startNode = $node // $self->{root};
    my $visited = { $startNode => 1};
    my @nodeQueue = ($startNode);

    while(@nodeQueue) {
        my $node = shift(@nodeQueue);
        if ($node->{type} eq $tag){
            return $node;
        }

        my $child = $node->{child};
        my @children = ();
        while ($child) {
            push @children, $child;
            $child = $child->{neighbor};
        }

        for my $child (@children) {
            next if $visited->{$child};
            $visited->{$child} = 1;
            push @nodeQueue, $child;
        }
    }

    return undef;
}

1;
