use SDB::Install::SysVars;
# use SDB::Install::DebugUtilities;
use LCM::ProcessExecutor;
use SAPDB::Install::System::Win32::Registry;

#----------------------------------------------------------------------------

sub Postinstall() {
    my (
        $self
    ) = @_;
    return $self->_install(1);
}

#----------------------------------------------------------------------------

sub Preuninstall() {
    my (
        $self
    ) = @_;
    return $self->_install(0);
}

#----------------------------------------------------------------------------

sub _install() {
    my (
        $self,
        $register # 1 for install, 0 for uninstall
    ) = @_;
    my $path = $self->getPath();
    my $dotnetInfo = $self->_getDotNetInfo();
    if(not defined $dotnetInfo) {
        return undef;
    }
    my $actionCaption = $register ? 'Registering' : 'Unregistering';
    if(not $dotnetInfo) {
        $self->AddMessage("Not $actionCaption ADO.NET provider:  no suitable .NET version found.");
        return 1;
    }
    my $adoDir = $path.'\\ado.net';
    my $dotnetVersion = $dotnetInfo->{'version'};
    my $msg = $self->AddMessage("$actionCaption ADO.NET provider for $dotnetVersion");
    my $adoSetup = $adoDir.'\\'.$dotnetInfo->{'setup'};
    my $exer = undef;
    my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime();
    my $timestamp = sprintf("%04d%02d%02d%02d%02d", $year, $mon, $mday, $hour, $min);
    if($register) {
        # e.g. "C:\hdbclient\ado.net\v4.5\SetupNet.v4.5.exe /i /hl C:\hdbclient\ado.net /log %TEMP%\hdbadonet-yyyymmddhhss-install.log /silent"
        $exer = new LCM::ProcessExecutor($adoSetup, [ '/i', '/hl', $adoDir, '/log', $ENV{'TEMP'}."\\hdbadonet-$timestamp-install.log" ]);
    }
    else {
        # e.g. "C:\hdbclient\ado.net\v4.5\SetupNet.v4.5.exe /silent /log %TEMP%\hdbadonet-yyyymmddhhss-uninstall.log /u"
        $exer = new LCM::ProcessExecutor($adoSetup, [ '/log', $ENV{'TEMP'}."\\hdbadonet-$timestamp-uninstall.log", '/u' ]);
    }
    my $exitCode = $exer->executeProgram();
    if (!defined $exitCode || $exitCode){
        $self->AddSubMsgLst ($msg, $exer->getMsgLst());
        $self->AddError($exer->getErrorString());
        return undef;
    }
    $self->AddSubMsgLst ($msg, $exer->getMsgLst());
    return 1;
}

#----------------------------------------------------------------------------

# returns one hash from the list below, or 0 for nothing found(, or undef for error)
sub _getDotNetInfo() {
    my (
        $self
    ) = @_;
    my $rootKey = HKEY_LOCAL_MACHINE;
    my $versions = [ # first match will be processed in _install():
        {
            'version' => 'v4.5', # for display in output and log.
            'regKey'  => 'SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v4\\Client',
            'setup'   => 'v4.5\\SetupNet.v4.5.exe'
        },
        {
            'version' => 'v3.5', # for display in output and log.
            'regKey'  => 'SOFTWARE\\Microsoft\\NET Framework Setup\\NDP\\v2.0.50727',
            'setup'   => 'v3.5\\SetupNet.v3.5.exe'
        }
    ];
    my $retval = 0;
    foreach $entry (@{$versions}) {
        my $hKey;
        my $desi = KEY_QUERY_VALUE | KEY_WOW64_64KEY;
        my $rc = RegOpenKeyEx($rootKey, $entry->{'regKey'}, 0, $desi, $hKey);
        if($rc != 0) {
            next;
        }
        my $str;
        my $size;
        $rc = RegQueryValueEx($hKey, "Install", 0, 0, $str, \$size);
        if($rc == 0) {
            $retval = $entry;
            RegCloseKey($hKey);
            last;
        }
    }
    return $retval;
}

1;
