use SDB::Install::SysVars;
use SDB::Install::DebugUtilities;
use SDB::Install::System qw (
    exec_program
);
use SDB::Install::System::Registration::ODBC;



sub Register{
    my ($self) = @_;
    if ($isWin){
        my $inst              = $self->{'installation'};
        my $conf              = $inst->getConfiguration();
        my $driverName        = $conf->{'params'}->{'ODBCDriverName'}->{'value'};
        my $path              = $self->getPath ();
        my $odbcreg           = $path . $path_separator . 'odbcreg.exe';
        my $dll               = 'libodbcHDB.dll';
        if(! -f $odbcreg) {
            $odbcreg = $path . $path_separator . 'odbcreg32.exe';
            $dll = 'libodbcHDB32.dll';
        }
        if(not $self->IsUpdate()) {
            # we only do registration when we are a new install, not a sw update.
    		my $msg = $self->AddMessage ("Registering ODBC driver as \"$driverName\".");
    		my $cfg =  {};
    		my $rc = exec_program ($odbcreg, ['-i', $driverName, '-p',$path, '-d', $dll],$cfg);
    		if (!defined $rc || $rc != 0){
    			$self->AddError ("Could not register ODBC driver \"$driverName\"", $cfg);
    			$self->AddSubMsgLst ($msg, $cfg);
    			return undef;
    		}
    		$self->AddSubMsgLst ($msg, $cfg);
        }
        else {
            # when we are a sw update, we give a warning when we
            # could not find a registration of our driver in the registry.
            # Note that registrations may have been deleted intentionally,
            # e.g. for security reasons.
            my $odbcObj = new SDB::Install::System::Registration::ODBC();
            my $myNames  = $odbcObj->getDriverNamesAssignedToInstallation($inst);
            if( (not defined $myNames) || scalar(@{$myNames}) <= 0) {
                $self->AddWarning("ODBC Driver \"".$path.$path_separator.$dll."\" is not registered.");
                $self->AddWarning("If this is not intentional, registration could be done as follows:");
                $self->AddWarning("\"$odbcreg\" -i <driverName> -p \"$path\" -d $dll");
            }
        }
	}
	return 1;
}

#----------------------------------------------------------------------------

sub Unregister{
	my (
	   $self
    ) = @_;
	if ($isWin){
        my $inst        = $self->{'installation'};
        my $conf        = $inst->getConfiguration();
		my $path        = $self->getPath();
		my $odbcreg     = $path . $path_separator . 'odbcreg.exe';
        if (! -f $odbcreg){
            $odbcreg = $path . $path_separator . 'odbcreg32.exe';
        }
        my $odbcObj = new SDB::Install::System::Registration::ODBC();
        my $myNames  = $odbcObj->getDriverNamesAssignedToInstallation($inst);
        if(defined $myNames) {
            foreach my $driverName (@$myNames) {
        		my $msg = $self->AddMessage ("Unregistering ODBC driver \"$driverName\".");
        		my $cfg =  {};
        		my $rc = exec_program($odbcreg, ['-r', $driverName], $cfg);
        		if (!defined $rc || $rc != 0){
        			$self->AddError("Could not unregister ODBC driver \"$driverName\".", $cfg);
        			$self->AddSubMsgLst($msg, $cfg);
        			return undef;
        		}
        		$self->AddSubMsgLst($msg, $cfg);
            }
        }
	}
	return 1;
}

#----------------------------------------------------------------------------

sub Postinstall() {
        my (
            $self
        ) = @_;
        my $path = $self->getPath();
        my $exeExt = $isWin ? '.exe' : '';
        my $odbcCons = $path.$path_separator.'hdbodbc_cons'.$exeExt;
        if(! -f $odbcCons) {
            $odbcCons = $path.$path_separator.'hdbodbc_cons32'.$exeExt;
        }
        if(-f $odbcCons) {
            $self->AddMessage("Running $odbcCons to detect and remove invalid shared memory.");
            my $rc = exec_program($odbcCons, ['-w', '256']);
            if(defined $rc) {
                $self->AddMessage("$odbcCons returned $rc.");
            }
        }
        return 1;
}


1;
