use SDB::Install::SysVars;
use SDB::Install::System qw (exec_program getSysPath);


our $driverName = 'SAP HANA for MS Excel';
our  @dlls = qw (SAPNewDBMDXProvider.dll SAPNewDBMDXProviderEr.dll);

sub Register{
    my ($self) = @_;

    my $path = $self->getPath ();
    my $odbcreg = $path . $path_separator . 'odbcreg.exe';
    my $dll = 'libodbcHDB.dll';
    my $hdbodbc = 'HDBODBC';

    if (! -f $odbcreg){
        $odbcreg = $path . $path_separator . 'odbcreg32.exe';
        $dll = 'libodbcHDB32.dll';
        $hdbodbc = 'HDBODBC32';
    }

    my $msg = $self->AddMessage ("Registering ODBC driver");
    my $cfg =  {};
    my $rc = exec_program ($odbcreg, ['-i', $driverName, '-p',$path, '-d', $dll],$cfg);
    if (!defined $rc || $rc != 0){
        $self->AddError ("Cannot register ODBC driver", $cfg);
        $self->AddSubMsgLst ($msg, $cfg);
        return undef;
    }
    my $rc2 = exec_program ($odbcreg, ['-i', $hdbodbc, '-p',$path, '-d', $dll],$cfg);
    if (!defined $rc2 || $rc2 != 0){
        $self->AddError ("Cannot register ODBC driver as \"$hdbodbc\"", $cfg);
        $self->AddSubMsgLst ($msg, $cfg);
        return undef;
    }
    $self->AddSubMsgLst ($msg, $cfg);

    my $errlst = new SDB::Install::MsgLst ();
    my $system32 = getSysPath ($errlst);
    if (!defined $system32){
        $self->AddError ("Cannot determine system32 path", $errlst);
        return undef;
    }
    my $regsvr32 = $system32 . $path_separator . 'regsvr32.exe';
    $msg = $self->AddMessage ("Registering MDX provider");
    local %ENV = %ENV;
    $ENV{PATH} = $path . $env_path_separator . $ENV{PATH};
    foreach my $dll (@dlls){
        $cfg = {};
        $rc = exec_program ($regsvr32, ['/s', $path . $path_separator . $dll], $cfg);
        if (!defined $rc || $rc != 0){
            $self->PushError ("Cannot register MDX provider", $cfg);
            $self->AddSubMsgLst ($msg, $cfg);
            return undef;
        }
        $self->AddSubMsgLst ($msg, $cfg);
    }
    return 1;
}


sub Unregister{
    my ($self) = @_;

    my $path = $self->getPath ();
    my $odbcreg = $path . $path_separator . 'odbcreg.exe';
    if (! -f $odbcreg){
        $odbcreg = $path . $path_separator . 'odbcreg32.exe';
    }

    my $msg = $self->AddMessage ("Unregistering ODBC driver");
    my $cfg =  {};
    my $rc = exec_program ($odbcreg, ['-r', $driverName]);
    if (!defined $rc || $rc != 0){
        $self->AddError ("Cannot unregister ODBC driver", $cfg);
        $self->AddSubMsgLst ($msg, $cfg);
        return undef;
    }
    $self->AddSubMsgLst ($msg, $cfg);

    my $errlst = new SDB::Install::MsgLst ();
    my $system32 = getSysPath ($errlst);
    if (!defined $system32){
        $self->AddError ("Cannot determine system32 path", $errlst);
        return undef;
    }
    my $regsvr32 = $system32 . $path_separator . 'regsvr32.exe';
    $msg = $self->AddMessage ("Unregistering MDX provider");
    local %ENV = %ENV;
    $ENV{PATH} = $path . $env_path_separator . $ENV{PATH};
    foreach my $dll (@dlls){
        $cfg = {};
        $rc = exec_program ($regsvr32, ['/u','/s', $path . $path_separator . $dll], $cfg);
        if (!defined $rc || $rc != 0){
            $self->PushError ("Cannot unregister MDX provider", $cfg);
            $self->AddSubMsgLst ($msg, $cfg);
            return undef;
        }
        $self->AddSubMsgLst ($msg, $cfg);

    }
    return 1;
}

sub Postinstall() {
        my (
            $self
        ) = @_;
        my $path = $self->getPath();
        my $exeExt = $isWin ? '.exe' : '';
        my $odbcCons = $path.$path_separator.'hdbodbc_cons'.$exeExt;
        if(! -f $odbcCons) {
            $odbcCons = $path.$path_separator.'hdbodbc_cons32'.$exeExt;
        }
        if(-f $odbcCons) {
            $self->AddMessage("Running $odbcCons to detect and remove invalid shared memory.");
            my $rc = exec_program($odbcCons, ['-w', '256']);
            if(defined $rc) {
                $self->AddMessage("$odbcCons returned $rc.");
            }
        }
        return 1;
}


1;
