package BuildPackage::Vars;

use Cwd qw(realpath);
use Config;

use SDB::Install::DebugUtilities;
use SDB::Install::System qw(isAbsolute);
use BuildPackage::Tools;
use SDB::Install::Installer;

# -----------------------------------------------------------------------------------------
our $haveXMLLib = 0;
eval {
    require XML::LibXML;
};
if($@) {
    print STDERR "Warning: Cannot load XML::LibXML => No package XML validation will be performed ".
            "However, packaging is unaffected.\n";
}
else {
    $haveXMLLib = 1;
}

#----------------------------------------------------------------------------

sub new {
    my $self =  bless({},shift);
    my (
        $wrkdir,
        $makeoutpdir,
        $packdefdir,
        $threads,
        $makeid,
        $package,
        $verbose,
        $kitname,
        $addenv
    ) = @_;
    $self->{'MakeInfos'} = {};
    # get compiler infos and make environment:
    if(exists $ENV{'TOOLVARS'} && defined $ENV{'TOOLVARS'} && -f $ENV{'TOOLVARS'}) {
        do $ENV{'TOOLVARS'};
    }
    my %myenv = %ENV;
    $self->{'MakeEnv'} = \%myenv;
    if(defined $addenv) {
        foreach my $entry (split(',', $addenv)){
            my ($varName, $value) = ($entry =~ /([^=]*)=(.*)/);
            if(defined $varName && (not $varName eq '')) {
                if(defined $value && (not $value eq '')) {
                    $self->{'MakeEnv'}->{$varName} = $value;
                }
                else {
                    delete $self->{'MakeEnv'}->{$varName};
                }
            }
        }
    }

    my $installer = new  SDB::Install::Installer ();

    ## -----------------------------------------------------------------------------------------
    # do we run from the LCMsdk, or are we packaging NewDB?
    # the criterion is the nonexistence of "hdbinst" in the buildpackage runtime dir (== SDK mode).
    my $exeExt = ($^O =~ /mswin/i) ? '.exe' : '';

    $rtDir = $installer->getInstallerDir ();
    $rtDir = realpath($rtDir);
    my $hdbinstExe = $rtDir.'/hdbinst'.$exeExt;
    $self->{'SDK_MODE'} = (-f $hdbinstExe) ? 0 : 1;
    ## -----------------------------------------------------------------------------------------
    $self->{'haveXMLLib'} = $haveXMLLib;
    ## -----------------------------------------------------------------------------------------
    my $callerdir = $installer->getCallerDir ();
    if(defined $wrkdir && !isAbsolute($wrkdir)) {
        $wrkdir = realpath($callerdir.'/'.$wrkdir);
    }
    if(defined $makeoutpdir && !isAbsolute($makeoutpdir)) {
        $makeoutpdir = realpath($callerdir.'/'.$makeoutpdir);
    }
    if(defined $packdefdir && !isAbsolute($packdefdir)) {
        $packdefdir = realpath($callerdir.'/'.$packdefdir);
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'MAKETYPE'} = 'sdk';
    if(not $self->{'SDK_MODE'}) {
        if(exists $self->{'MakeEnv'}->{'MAKETYPE'} &&
           defined $self->{'MakeEnv'}->{'MAKETYPE'} && 
           not ($self->{'MakeEnv'}->{'MAKETYPE'} eq '')) {
            $self->{'MAKETYPE'} = $self->{'MakeEnv'}->{'MAKETYPE'};
        }
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'TMP'} = undef;
    if(not $self->{'SDK_MODE'}) {
        if(exists $self->{'MakeEnv'}->{'TMP'} && defined $self->{'MakeEnv'}->{'TMP'}){
            $self->{'TMP'} = $self->{'MakeEnv'}->{'TMP'};
        }
    }
    if(defined $wrkdir) {
        $self->{'TMP'} = $wrkdir.'/tmp';
    }
    if(!defined $self->{'TMP'}) {
        die("unknown tmpdir. Use -work option.\n");
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'MAKEOUTPDIR'} = undef;
    if(not $self->{'SDK_MODE'}) {
        if(exists $self->{'MakeEnv'}->{'OWN'} && defined $self->{'MakeEnv'}->{'OWN'}){
            $self->{'MAKEOUTPDIR'} = $self->{'MakeEnv'}->{'OWN'}.'/gen/'.$self->{'MAKETYPE'};
        }
        if(exists $self->{'MakeEnv'}->{'GEN_DIR'} && defined $self->{'MakeEnv'}->{'GEN_DIR'}){
            $self->{'MAKEOUTPDIR'} = $self->{'MakeEnv'}->{'GEN_DIR'};
        }
    }
    if(defined $makeoutpdir) {
        $self->{'MAKEOUTPDIR'} = $makeoutpdir;
    }
    if(!defined $self->{'MAKEOUTPDIR'}) {
        die("gen dir not specified. Use -gen option.\n");
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'KITDIR'} = undef;
    if(not $self->{'SDK_MODE'}) {
        my $_kitname = $kitname;
        if(not defined $_kitname) {
            $_kitname = '__installer.HDB';
        }
        if(exists $self->{'MakeEnv'}->{'OWN'} && defined $self->{'MakeEnv'}->{'OWN'}){
            $self->{'KITDIR'} = $self->{'MakeEnv'}->{'OWN'}.'/gen/'.$self->{'MAKETYPE'}.'/'.$_kitname;
        }
        if(exists $self->{'MakeEnv'}->{'GEN_DIR'} && defined $self->{'MakeEnv'}->{'GEN_DIR'}){
            $self->{'KITDIR'} = $self->{'MakeEnv'}->{'GEN_DIR'}.'/'.$_kitname;
        }
    }
    if(defined $wrkdir) {
        my $_kitname = $kitname;
        if(not defined $_kitname) {
            $_kitname = 'installer';
        }
        $self->{'KITDIR'} = $wrkdir.'/'.$_kitname;
    }
    if(!defined $self->{'KITDIR'}) {
        die("unknown kitdir. Use -work option.\n");
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'GENERIC_KITSUBDIR'} = $self->{'KITDIR'}.'/packages';
    ## -----------------------------------------------------------------------------------------
    ## -----------------------------------------------------------------------------------------
    $self->{'BUILDPACKAGE_VERSION'} = '2.0';
    ## -----------------------------------------------------------------------------------------
    # where buildpackage and installerfiles are: RuntimeDir, RuntimeDir/lib 
    $self->{'STAGEDIR'} = $installer->getInstallerDir ();
    if(not $self->{'SDK_MODE'}) {
        if(exists $self->{'MakeEnv'}->{'WRK'} && defined $self->{'MakeEnv'}->{'WRK'}){
            $self->{'STAGEDIR'} = $self->{'MakeEnv'}->{'WRK'}.'/'.$self->{'MAKETYPE'}.'/install';
        }
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'STAGELIBDIR'} = $self->{'STAGEDIR'}.'/lib';
    ## -----------------------------------------------------------------------------------------
    $self->{'PACKDEFDIR'} = $self->{'STAGEDIR'}.'/allpackages';
    if(defined $packdefdir) {
        $self->{'PACKDEFDIR'} = $packdefdir;
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'PATH'} = (exists $self->{'MakeEnv'}->{'PATH'}) ? $self->{'MakeEnv'}->{'PATH'} : undef;
    ## -----------------------------------------------------------------------------------------
    $self->{'HDB_STATE'} = (exists $self->{'MakeEnv'}->{'HDB_STATE'}) ? $self->{'MakeEnv'}->{'HDB_STATE'} : undef;
    ## -----------------------------------------------------------------------------------------
    $self->{'BP_USE_PIGZ'} = (exists $self->{'MakeEnv'}->{'BP_USE_PIGZ'}) ? $self->{'MakeEnv'}->{'BP_USE_PIGZ'} : undef;
    ## -----------------------------------------------------------------------------------------
    $self->{'PIGZ_BIN'} = (exists $self->{'MakeEnv'}->{'PIGZ_BIN'}) ? $self->{'MakeEnv'}->{'PIGZ_BIN'} : undef;
    ## -----------------------------------------------------------------------------------------
    $self->{'BP_PIGZ_RSYNCABLE'} = (exists $self->{'MakeEnv'}->{'BP_PIGZ_RSYNCABLE'}) ? $self->{'MakeEnv'}->{'BP_PIGZ_RSYNCABLE'} : undef;
    ## -----------------------------------------------------------------------------------------
    ## -----------------------------------------------------------------------------------------
    if($self->{'SDK_MODE'}) {
        my $installerManifest = $self->{'STAGELIBDIR'}.'/manifest';
        if(not -f $installerManifest) {
            die("Could not access manifest '$installerManifest' : $!\n");
        }
        my $mf = new SDB::Install::Manifest($installerManifest);
        if(not defined $mf) {
            die("Could not read manifest '$installerManifest' : $!\n");
        }
        $self->{'INSTALLER_MANIFEST_OBJ'} = $mf;
        my $platformKey = 'platform';
        my $platform = $mf->getValue($platformKey);
        if(!defined $platform) {
            die("Key '$platformKey' not found in manifest '$installerManifest'.\n");
        }
        if($platform =~ /^NTamd64$/) {
            $self->{'WINBIT64'} = 1;
        }
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'PACKDEF_MASTER_XML'} = $self->{'PACKDEFDIR'}.'/allpackages.xml';
    ## -----------------------------------------------------------------------------------------
    if($self->{'SDK_MODE'}) {
        $self->{'PACKDEF_MASTER_XML_SCHEMA'} = $self->{'STAGELIBDIR'}.'/allpackages.xsd';
    }
    else {
        $self->{'PACKDEF_MASTER_XML_SCHEMA'} = $self->{'PACKDEFDIR'}.'/allpackages.xsd';
    }
    ## -----------------------------------------------------------------------------------------
    if($self->{'SDK_MODE'}) {
        $self->{'INSTALLCFG_DTD_SRC'} = $self->{'STAGELIBDIR'}.'/installcfg.dtd';
        ## -----------------------------------------------------------------------------------------
        $self->{'INSTALLCFG_DTD'} = 'installcfg.dtd';
        ## -----------------------------------------------------------------------------------------
        $self->{'INSTALLPARAMS_XML_SRC'} = $self->{'PACKDEFDIR'}.'/InstallParams.xml';
        ## -----------------------------------------------------------------------------------------
        $self->{'INSTALLPARAMS_XML'} = 'InstallParams.xml';
        ## -----------------------------------------------------------------------------------------
        $self->{'CUSTOMMODULES_SRCDIR'} = $self->{'PACKDEFDIR'}.'/CustomModules';
        ## -----------------------------------------------------------------------------------------
        $self->{'CUSTOMMODULES_DIR'} = 'CustomModules';
        ## -----------------------------------------------------------------------------------------
        $self->{'INSTALLER_RUNTIME_DEF'} = $self->{'STAGELIBDIR'}.'/instruntime.xml';
    }
    ## -----------------------------------------------------------------------------------------
    $self->{'PACKAGE'} = $package;
    ## -----------------------------------------------------------------------------------------
    $self->{'THREADCOUNT'} = 1;
    if(defined $threads && $threads > 1) {
        $self->{'THREADCOUNT'} = $threads;
    }
    elsif (%BuildPackage::Worker:: && defined $BuildPackage::Worker::{'getThreadNum'}){
        $self->{'THREADCOUNT'} = &{$BuildPackage::Worker::{'getThreadNum'}} ();
    }
    ## -----------------------------------------------------------------------------------------
    return $self;
}

#----------------------------------------------------------------------------

1;

