package LCM::ActionsDetector::Action::UpdateComponents;

use strict;
use warnings;
use parent 'LCM::ActionsDetector::Action';


sub new {
    my ($class, $pendingInfo) = @_;
    my $self = $class->SUPER::new();
    $self->{pendingInfo} = $pendingInfo;
    return $self;
}

sub getKey {
    my ($self) = @_;
    return 'UpdateComponents';
}

sub getBatchKey {
    my ($self) = @_;
    return 'update_components';
}

sub getUIString {
    my ($self) = @_;
    my $pendingInfo = $self->getPendingInfo();
    return sprintf("Install or Update Additional Components%s", $pendingInfo);
}

sub getPendingInfo {
    my ($self) = @_;
    return $self->{pendingInfo};
}

1;