package LCM::AdditionalHostHelper;
use strict;
use base 'Exporter';

use SDB::Install::Globals qw ($gHostRoleWorker
                              $gHostRoleEsWorker
                              $gHostRoleAcceleratorWorker
                              );

our $SP_AUTO_ASSIGN = "<<assign automatically>>";
our $SP_NA = "N/A";

our @EXPORT = qw ($SP_AUTO_ASSIGN $SP_NA);

sub new {
	my ( $class, $hostObj, $suppressDefaults ) = @_;
	
	bless ($hostObj, $class);
	
	$hostObj->{suppressDefaults} = $suppressDefaults;
	
	return $hostObj;
}

sub getHost {
	return $_[0]->{host};
}

sub getRole {
	return $_[0]->{role};
}

sub getGroup {
	return $_[0]->{group};
}

sub getWorkerGroups {
	return $_[0]->{workergroup};
}

sub getGroupDisplayValue {
	my $group = $_[0]->getGroup();
	if (!$group) {
		return '';
	}
	return $group;
}

sub getStoragePartition {
	return $_[0]->{storage_partition};
}

sub getRoleDisplayValue {
	my $role = $_[0]->getRole();
	if (!$role) {
		return $gHostRoleWorker;
	}
	return $role;
}

sub getStoragePartitionDisplayValue {
	my $role = $_[0]->getRole();
	my $sp = $_[0]->getStoragePartition();
	
	if ($sp) {
		return $sp;
	}
	return '' if $_[0]->{suppressDefaults};

	return (shouldDisplayAutoAssign($role))? $SP_AUTO_ASSIGN: $SP_NA ;
}

sub getWorkerGroupDisplayValue {
	my $self = shift();
	my $workerGroup = $self->getWorkerGroups();

	return $workerGroup if($workerGroup);
	return $self->{suppressDefaults} ? '' : 'default';
}

sub shouldDisplayAutoAssign {
    my ($role) = @_;
    return ($role =~ /\b($gHostRoleWorker|$gHostRoleEsWorker|$gHostRoleAcceleratorWorker)/ )? 1: 0;
}

return 1;