package LCM::App::HdbLcmExternalConsole;

use strict;
use base qw (LCM::App::BaseApplication);

use LCM::Task::GenericStackTask::InstallProcessTask;
use LCM::Task::GenericStackTask::UpdateProcessTask;
use LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask;
use LCM::Task::PrintDetectedComponentsProcessTask;
use LCM::Task::HelpProcessTask;
use LCM::Task::DumpConfigfileTemplateProcessTask;
use LCM::Configuration::HdblcmExternalActionConfiguration;
use LCM::ComponentProgressHandler;
use LCM::ComponentManager::LogDetectedComponentsOutputHandler;

sub createExecutor {
	my ( $self, $action ) = @_;

	my $executor = undef;
    if ($self->isHelp()) {
        return LCM::Task::HelpProcessTask->new($self->getInstconfig(), $self);
    } elsif ($self->isDumpTemplate()) {
        return LCM::Task::DumpConfigfileTemplateProcessTask->new($self->getInstconfig(), $self);
    } elsif ('install' eq $action ){
		$executor = new LCM::Task::GenericStackTask::InstallProcessTask( $self->getInstconfig());
	} elsif ('update' eq $action ) {
		$executor = new LCM::Task::GenericStackTask::UpdateProcessTask( $self->getInstconfig());
	} elsif ('extract_components' eq $action) {
		$executor = new LCM::Task::ExtractComponentsTask::ExtractComponentsProcessTask($self->getInstconfig());
	} elsif ('print_detected_components' eq $action) {
		$executor = new LCM::Task::PrintDetectedComponentsProcessTask($self->getInstconfig());
	} else {
		...
	}
	
	$executor->addListener(new LCM::ComponentProgressHandler());
	return $executor;
}

sub createConfiguration {
	my ( $self, $action ) = @_;
	require  LCM::Configuration::GenericStackConfigurationFactory;
	my $config;
	my $actionConfig = $self->getActionConfiguration();
	if ( 'install' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createInstallConfiguration($self);
        my $componentMgr = $actionConfig->getComponentManager()->clone();
        $componentMgr->addComponentsOutputHandler(LCM::ComponentManager::LogDetectedComponentsOutputHandler->new());
        $config->setComponentManager($componentMgr);
	} elsif ( 'update' eq $action ) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createUpdateConfiguration($self);
        my $componentMgr = $actionConfig->getComponentManager()->clone();
        $componentMgr->addComponentsOutputHandler(LCM::ComponentManager::LogDetectedComponentsOutputHandler->new());
        $config->setComponentManager($componentMgr);
	} elsif ('extract_components' eq $action) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createExtractComponentsConfiguration($self);
	} elsif ('print_detected_components' eq $action) {
		$config = LCM::Configuration::GenericStackConfigurationFactory::getInstance()->createPrintDetectedComponentsConfiguration($self);
		my $componentMgr = $actionConfig->getComponentManager()->clone();
		$config->setComponentManager($componentMgr);
	}
# Added because of TIPHANA15IT10-2040
# a 'kit' property is needed in the CollectOtherHostInfos
# method in AnyConfig in case of non-resident hdblcm
	if (defined $config && defined $actionConfig->{kit}) {
		$config->{kit} = $actionConfig->{kit};
	}
	return $config;
}

sub createActionConfiguration {
	my $self = shift;
    return new LCM::Configuration::HdblcmExternalActionConfiguration( $self->{options}, $self->{configfile}, $self->{batch_mode} );
}

sub handleReturnCodes {
	my ( $self, $err, $rc ) = @_;
	
	my $action = $self->{action};
	
	if (defined $rc && $rc == 3 && defined $action) {
		#validation error occurred - do not print help
		$rc = undef;
	}

	return $self->SUPER::handleReturnCodes( $err, $rc );
}

sub isResident {
    return 0;
}

sub getFlavour {
    my ($self) = @_;
    return $self->getActionConfiguration()->getFlavour();
}

sub getListSystems{
    my $self = shift;
    require LCM::Configuration::ListSystemsActionConfiguration;
    $self->setActionConfiguration(LCM::Configuration::ListSystemsActionConfiguration->new());
    return $self->SUPER::getListSystems();
}

1;
