package LCM::Component::Installable::HDBClient::HDBClientSidAdm;

use LCM::Component;
use LCM::Component::Installable::HDBClient::HDBClientBase;
use SDB::Install::Globals qw(determineSignedManifestContainingDirectory $gOperationClientInstall);
use SDB::Install::SysVars qw($isWin);
use strict;

use base 'LCM::Component::Installable::HDBClient::HDBClientBase';

sub updateComponent {
    my ($self) = shift;
    return $self->installComponent(@_);
}

sub installComponent {
	my ($self, $instconfig) = @_;

	my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
	my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
	my $operation = $gOperationClientInstall;
	my $manifestDir = determineSignedManifestContainingDirectory($self->getInstallerDir());
	my $optionMap = {
		'CLIENT_CMP_PATH' => $self->getInstallerDir(),
		'MANIFEST_PATH' => $manifestDir,
	};
	my $args = $self->_buildArgs($instconfig);
	if (!defined $args){
		return undef;
	}
	$optionMap = $self->buildSHAOptionsMap($instconfig, $optionMap, $args, 1);

	$self->initProgressHandler ();

	my $rc = $self->installThroughSHAOperation($instconfig, $operation, $optionMap, undef, 1);

	if(!$isWin && $rc)
	{
		my $path = $self->getClientPath($instconfig);
		my $defaultPath = $instconfig->getDefault("ClientPath");
		if($path ne $defaultPath) {
			if(!symlink ($path, $defaultPath)){
				$self->getMsgLst ()->addWarning("Cannot create symbolic link to the custom location $path.");
			}
		}
	}

	my $action = $self->isUpdate ? 'Update' : 'Install';
	$msg->endMessage (undef, $action. ' ' . $self->getComponentName());
	$self->setMsgLstContext($saveCntxt);

	return $rc;	
}

sub updateSHAOptionsMap {
	my ($self, $optionMap, $newInstallationKitPath) = @_;
	$optionMap->{CLIENT_CMP_PATH} = $newInstallationKitPath;
	$optionMap->{MANIFEST_PATH} = $newInstallationKitPath;
	$optionMap->{ARCHIVE_DIR} = $self->getPath();
}

sub getFilelistFileName {
	return 'filelist.clientinst';
}

sub getCopyInstallerOperation {
	return 'HdbCopyClientInstaller_v3';
}

sub getDeleteCopiedInstallerOperation {
	return 'HdbRemoveCopiedClientInstaller_v2';
}

sub getCopiedInstallerDirPrefix {
	return 'client_installer_kit_';
}

1;
