package LCM::Component::Installable::HDBServer::HDBServerRoot;

use SDB::Install::SysVars qw($path_separator);
use SDB::Install::System qw(makedir);
use SDB::Install::Globals qw($gLogDir $gProductNameEngine);
use SDB::Install::Configuration::NewDB;
use SDB::Install::SAPSystem qw (CleanupSAPSystemCache);
use LCM::Configuration::GenericStackAny qw ($ini_section_server);
use LCM::ProcessExecutor;
use LCM::ExecutionWarningsObservable;
use File::stat;

use strict;
use base 'LCM::Component::Installable::HDBServer::HDBServerBase';

our $hdbUpdateExecutable = 'hdbupd';
our $AddSidadmTimeZoneSHAConfiguration = 'HdblcmAddSidadmTimeZone';

sub _buildArgs {
    my ($self, $instconfig) = @_;
    my $args = $self->SUPER::_buildArgs($instconfig);
    my $stdinLines = $instconfig->getXmlPasswordStream();

    if (defined $stdinLines) {
        push @{$args}, '--read_password_from_stdin=xml';
    }

    push @{$args}, '--batch';
    return $args;
}

# renamed from 'apply':
sub installComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $cfg = { 'mode' => 0755 };
    # create directories for data and log volumes
    for my $basePathID ('BasePathDataVolumes', 'BasePathLogVolumes') {
        my $basepath = $instconfig->getValue($basePathID);
        next if File::stat::stat($basepath);

        $self->getMsgLst ()->addMessage("Creating directory '$basepath'");
        if (!defined makedir ($basepath,$cfg)){
            $self->setErrorMessage ("Cannot create directory '$basepath'", $cfg);
            $msg->endMessage (undef, 'Install ' . $self->getComponentName());
            $self->setMsgLstContext($saveCntxt);
            return undef;
        }

    }

    my $command = $self->getHdbInstallExecutable();
    my $args = $self->_buildArgs($instconfig);
    my $stdinLines = $instconfig->getXmlPasswordStream();
    my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        $self->setErrorMessage ('Installation of ' . $self->getComponentName() . ' failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }

    $msg->endMessage (undef, 'Install ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    CleanupSAPSystemCache();
    return $rc;
}

sub updateComponent {
    my ( $self, $instconfig ) = @_;
    my $msg = $self->getMsgLst ()->addProgressMessage ($self->getProgressMsg() . '...');
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);
    my $cfg = {};
    $self->initProgressHandler ();

	my $exitCode;
	my $rc = 1;
	my $command = $self->getHdbUpdateExecutable();
	my $args = $self->_buildArgs($instconfig);
    my $stdinLines = $instconfig->getXmlPasswordStream();
	my $exer = new LCM::ProcessExecutor($command, $args, $stdinLines);
	$exer->setOutputHandler($self->getProgressHandler ());
	$exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment());
	$exitCode = $exer->executeProgram();
	$self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
	$self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));

	#check for deploy content error. handle it as warning
    if ((defined $exitCode) && ($exitCode == 2)) {
        $self->getMsgLst()->addWarning("Problems occurred while importing delivery units (content)");
		LCM::ExecutionWarningsObservable->getInstance()->notifyWarning("'$gProductNameEngine' update finished with warning, because of\n" .
															"failed deployment of HANA content (part of '$gProductNameEngine' archive).\n" .
															"To retry the deployment, run hdblcm again and choose to resume the pending\n" .
															"'$gProductNameEngine' update. For next steps, check SAP Note 1795885.");
    } elsif (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages ($exer->getOutputLines());
        $self->setErrorMessage ('Update of ' . $self->getComponentName() . ' failed',
            $errMsgLst->isEmpty ? $exer->getErrMsgLst() : $errMsgLst);
        $rc = undef;
    }
	
	$msg->endMessage (undef, "Updating " . $self->getComponentName());
	$self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub getHdbUpdateExecutable{
    my ($self) = @_;
    return File::Spec->catfile($self->getInstallerDir(), $hdbUpdateExecutable);
}

sub  register{
    my ( $self, $instconfig, ) = @_;
    
    my $remoteExecution = $instconfig->{options}->{remote_execution};
    if (defined $remoteExecution && $remoteExecution eq 'saphostagent') {
        return 1; 
    }
    
    my $hdbInstance = $instconfig->{hdbInstance};
    my $binDir = $hdbInstance->get_globalTrexInstallProgamDir();
    my $shellScript = $binDir . $path_separator . 'hdbreg'; 
    
    my $args = [];
    push @$args, "--main", "SDB::Install::App::Console::DBUpgradeHost::main", "--batch";
    my $stdinLines = $instconfig->getXmlPasswordStream(['Password']);
    push @$args, '--instlog_dir=' . $gLogDir;
    if (defined $stdinLines) {
        push @$args, '--read_password_from_stdin=xml';
    }
    
    my $message = "Registering " . $self->getComponentName();
    $self->getMsgLst()->addProgressMessage( $message . "..." );
    my $executor = new LCM::ProcessExecutor($shellScript, $args, $stdinLines);
    my $rc = $executor->executeProgram(1); 
    
    $self->getMsgLst()->addMessage(undef, $executor->getMsgLst()); # appendMsgLst
    
    # Success exit code is 0
    if ( ! $rc ) {
        $self->getMsgLst()->addMessage( $message . " finished successfully");
    } else {
        $self->getMsgLst()->addError( $message . " finished with error");
    }
    
    return ( ! $rc );
}

1;