package LCM::Component::Installed::HDBStudio;

use SDB::Install::SysVars qw($isWin $path_separator);
use SDB::Install::System qw (deltree isAdmin);
use SDB::Install::Globals qw($gProductNameStudio);
use LCM::ProcessExecutor;
use LCM::HDBComponentsConfigurator qw($action_register $action_unregister);
use LCM::Component::Registrable qw($RETURN_CODE_SUCCESS $RETURN_CODE_ERROR);
use SDB::Install::Globals qw ($gKeynameEngine);
use strict;

use parent 'LCM::Component::Installed','LCM::Component::Registrable';

our $hdbUninstallExecutable = 'hdbuninst' . ($isWin ? '.exe' : '');

sub uninstallComponent{
    my ($self, $configuration) = @_;

    my $errlst = new SDB::Install::MsgLst;
    my $manifestDirectory = $self->getPath();
    my $repository_dir = $manifestDirectory . $path_separator . '..' . $path_separator . 'hdbstudio_update';
    if (!-d $repository_dir) {
        $self->getMsgLst()->addMessage ("No studio update repository found to uninstall: '$repository_dir' does not exist");
    } else {
        if (!deltree($repository_dir, $errlst)) {
            $self->setErrorMessage ("Cannot uninstall studio update repository at '$repository_dir'", $errlst);
        } else {
            $self->getMsgLst()->addMessage ("'$gProductNameStudio' update repository at '$repository_dir' deleted");
        }
    }

    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    my $command = $self->getHdbUninstallExecutable();
    my $args = [];
    push @$args, qw(-b), '--path='. $manifestDirectory;
    my $exer = new LCM::ProcessExecutor($command, $args);
    $self->initProgressHandler ();
    $exer->setOutputHandler($self->getProgressHandler ());
    $exer->setProcessEnvironment ($self->prepareHdbInstallerEnvironment ());
    my $exitCode = $exer->executeProgram();
    $self->getMsgLst ()->addMessage(undef, $exer->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($exer->getOutputLines()));
    
    
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($exer->getOutputLines());
        $errMsgLst = $exer->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $configuration, $errMsgLst);
        $rc = undef;
    } else {
	    $self->removeComponentDirectory($manifestDirectory);
	}

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);
    return $rc;
}

sub getNumberOfExpectedOutputLines { return 10; }

sub getComponentName {
	return $gProductNameStudio;
}

sub getHdbUninstallExecutable {
    my ($self) = @_;
    if (!defined $self->{hdbUninstallExecutable}){
        $self->{hdbUninstallExecutable} = $self->getHdbInstallerDir () . $path_separator . 'install' .
                $path_separator . $hdbUninstallExecutable;
        if (! -f $self->{hdbUninstallExecutable}){
            #
            # client installer package is not installed
            # => try server hdbuninst as workaround
            #
            my $componentManager = $self->getComponentManager ();
            my $serverComponent = $componentManager->getComponentByKeyName ($gKeynameEngine);
            if (defined $serverComponent){
                my $server_uninstaller = $serverComponent->getHdbUninstallExecutable ();
                if (-f $server_uninstaller){
                    $self->{hdbUninstallExecutable} = $server_uninstaller;
                }
            }
        }
    }
    return $self->{hdbUninstallExecutable};
}

sub register {
    my($self,$logger, $instconfig,$sharedDir,$sid) = @_;
    my $componentName = $self->getComponentName();
    $logger = defined($logger) ? $logger : $self;
    my $rc = $self->configureHdbComponents ($logger, ['hdbstudio'], $sharedDir, $sid, $action_register);

    return defined($rc) ? $RETURN_CODE_SUCCESS : $RETURN_CODE_ERROR;
}

sub unregister {
    my($self,$logger, $instconfig,$sharedDir,$sid) = @_;
    my $componentName = $self->getComponentName();
    $logger = defined($logger) ? $logger : $self;
    my $rc = $self->configureHdbComponents($logger, ['hdbstudio'], $sharedDir, $sid, $action_unregister);

    return defined($rc) ? $RETURN_CODE_SUCCESS : $RETURN_CODE_ERROR;
}

sub getSlppLogFileName {
	return 'studio.log'
}

1;
