package LCM::Component::Installed::LSS::LSSBase;

use strict;
use SDB::Install::Globals qw($gLogDir $gProductNameLSS $gSAPLocation);
use SDB::Install::System qw( readLink isLink );
use LCM::FileUtils qw(deleteFile);

use base 'LCM::Component::Installed';

our $uninstallScript = 'hdbuninst';

sub uninstallComponent {
    my ( $self, $instconfig ) = @_;
    my $rc = 1;
    my $msg = $self->getMsgLst ()->addProgressMessage ("Uninstalling " . $self->getComponentName() . "...");
    my $saveCntxt = $self->setMsgLstContext([$msg->getSubMsgLst ()]);

    my $componentManager = $instconfig->getSystemComponentManager();
    if(!$componentManager->isHDBServerComponentSelected()){
        $rc = $self->removeLssInstance($instconfig);
    }

    my $exitCode = $self->_uninstallLSS($instconfig);
    $rc = undef if(!$rc || !$exitCode);

    $msg->endMessage (undef, 'Uninstall ' . $self->getComponentName());
    $self->setMsgLstContext($saveCntxt);

    return $rc;
}

sub getLssExeDir {
    my ($self, $sid) = @_;

    my $lssLink = File::Spec->catfile($gSAPLocation, $sid, 'lss' , 'exe');
    my $isLink = SDB::Install::System::isLink($lssLink);
    return $isLink ? SDB::Install::System::readLink ( $lssLink ) : undef;
}

sub getComponentName {
    return $gProductNameLSS;
}

sub getNumberOfExpectedOutputLines{
    return 5;
}

sub _getExecutable {
    my ($self, $instconfig) = @_;
    my $lssInstallationPath = $instconfig->getValue('LSSInstallationPath');
    return File::Spec->catfile($lssInstallationPath, 'install', $uninstallScript);
}

sub removeRemoteLssInstances {
    ...
}

sub cleanRemoteHosts {
    my ($self, $instconfig, $lssInstance, $remoteHosts) = @_;

    my $rc = 1;
    foreach my $host (@$remoteHosts) {
        $rc &&= $lssInstance->disableService($host);
    }
    $rc &&= $self->removeRemoteLssInstances($instconfig, $remoteHosts);
    return $rc;
}

sub removeLssInstance {
    my ($self, $config) = @_;
    my $instance = $config->getOwnInstance();
    my $lssInstance =  (defined $instance) ? $instance->getLssInstance() : undef;

    if(! defined $lssInstance) {
        $self->getErrMsgLst()->addError("$gProductNameLSS instance cannot be found");
        return undef;
    }

    $lssInstance->setMsgLstContext($self->getMsgLstContext());
    my $rc = $lssInstance->disableService();

    my $remoteDbHosts = $config->getRemoteDBHosts();
    if(@$remoteDbHosts > 0){
        $rc &&= $self->cleanRemoteHosts($config, $lssInstance, $remoteDbHosts);
    }

    if($rc){
        my $lssLink = $lssInstance->getLssLink();
        $self->getMsgLst()->addMessage("Deleting $lssLink...");
        $rc &&= deleteFile($lssLink, $self->getErrMsgLst());
    }

    return $rc;
}

1;
