package LCM::Component::Installed::LSS::LSSRoot;

use strict;
use SDB::Install::Globals qw($gLogDir $gProductNameLSS $gSAPLocation);
use LCM::ProcessExecutor;

use base 'LCM::Component::Installed::LSS::LSSBase';

sub _uninstallLSS {
    my ($self, $instconfig) = @_;

    my $executor = $self->_createProcessExecutor($instconfig);
    $self->initProgressHandler ();
    $executor->setOutputHandler($self->getProgressHandler ());
    my $exitCode = $executor->executeProgram();
    $self->getMsgLst()->addMessage(undef, $executor->getMsgLst());
    $self->setLogLocation($self->parseLogFileLocation($executor->getOutputLines()));

    my $rc = 1;
    if (!defined $exitCode || $exitCode){
        my $errMsgLst = $self->getHdbInstallerErrorMessages($executor->getOutputLines());
        $errMsgLst = $executor->getErrMsgLst() if $errMsgLst->isEmpty();
        $self->_handleUninstallationExitCode($exitCode, $instconfig, $errMsgLst);
        $rc = undef;
    }
    return $rc;
}

sub _createProcessExecutor{
    my ($self, $instconfig) = @_;
    my $command = $self->_getExecutable($instconfig);
    my $arguments = $self->_buildUninstallArguments($instconfig);
    return new LCM::ProcessExecutor($command, $arguments);
}

sub _buildUninstallArguments {
    my ($self, $config) = @_;
    my $args = [ '--batch', "--instlog_dir=$gLogDir" ];
    push (@$args,'--keep_user') if ($config->getValue('KeepLSSUser'));
    push (@$args,'--keep_user_group') if ($config->getValue('KeepLSSUserGroup'));
    return $args;
}

sub removeRemoteLssInstances {
    my ($self, $instconfig, $remoteHosts) = @_;
    my $hdbuninst = $self->_getExecutable($instconfig);
    my $args = $self->_buildUninstallArguments($instconfig);
    push(@$args, '--main', 'SDB::Install::App::Console::LSS::RemoveHost::main');

    my $message = "Removing $gProductNameLSS from host %s";
    my $command = join (' ', $hdbuninst, @$args);
    my $remoteHostsObject = $instconfig->getRemoteHosts();
    my $saveCntxt = $remoteHostsObject->setMsgLstContext($self->getMsgLstContext());
    my $exitCode = $remoteHostsObject->executeParallel( $command, $message,undef, undef, undef, undef, $remoteHosts);
    my $rc = 1;
    if ($exitCode != 0) {
        $self->setErrorMessage( undef, $remoteHostsObject->getErrMsgLst());
        $rc = 0;
    }
    $remoteHostsObject->setMsgLstContext($saveCntxt);
    return $rc;
}

1;
