package LCM::ComponentManager::ResidentMediumComponentManager;

use strict;
use LCM::Configuration::ValueChangeListeners::ResidentUpdateComponentDetectionListener;
use base qw (LCM::ComponentManager::MediumComponentManager);

# Method is overriden to disable the addition of a server component because
# in case of a resident update/install, it's not possible to update the server.
sub addComponent{
    my ($self, $component) =  @_;
    return 1 if($component->isServer());
    return 1 if($component->isCockpitStack());
    return $self->SUPER::addComponent($component);
}

# Method is overriden because we do not want to update the
# resident installer in case of a resident update/installation
sub _addResidentInstallerComponent {
	return 1;
}

sub isResidentComponentManager {
    return 1;	
}

1;