package LCM::ComponentManager::UpdateSystemBootstrapComponentManager;

use strict;
use warnings;
use base qw (LCM::ComponentManager::MediumComponentManager);
use LCM::App::UpdateSystemUtils qw(getLCMFromServerPath);
use SDB::Install::Globals qw($gKeynameEngine);
use File::Basename;


# At the point this method is called, all the components have been already detected => they can be used
sub _addResidentInstallerComponent {
    my ($self) = @_;
    my $hanaServer = $self->getComponentByKeyName($gKeynameEngine);
# Do not handle the case when HDB is not detected => it will be handled in ServerDetectionListener.pm
    return 1 if !$hanaServer;

    my $kitLocation = dirname($hanaServer->getPath());
    my $lcmLocation = getLCMFromServerPath($kitLocation);
    return $self->addResidentInstallerComponent($lcmLocation);
}

1;