package LCM::ComponentProgressHandler;

use strict;
use parent 'SDB::Install::ProgressHandler';

sub addLine{
    my ($self, $line) = @_;
    if ($line =~ /Installing\s|Uninstalling\s|Renam\s|Updating\s|Starting|Stopping|All server processes|Importing\s|Creating\s|Adding\s|Copying\s|Preparing\s|Extracting\s|Unpacking\s|Configuring\s|Launching\s|Activating\s/){
        print ("  $line\n");
    }
}

sub notifyTaskChanged{
    my($self,$subtask) = @_;
    if(!$subtask->getStatus()->isInRunningState()){
    	return;
    }
    # ignore multiple notifications when there are no new progress messages
    my $lastSubtaskProgressMsg = $subtask->getLastProgressMessage();

    if (defined $lastSubtaskProgressMsg) {

        if (defined $self->{_progressMsg}
	        && ($self->{_progressMsg} eq $lastSubtaskProgressMsg)) {
            return;
        }
        print $lastSubtaskProgressMsg."\n";
        $self->{_progressMsg} = $lastSubtaskProgressMsg;
    }
}

1;
