package LCM::Configuration::AbstractExternalConfigurationFlavourFactory;

use strict;
use warnings;

use SDB::Install::Globals qw( $gFlavourCockpit );
use LCM::Configuration::Cockpit::CockpitExternalActionConfigurationFactory;
use LCM::Configuration::EngineExternalActionConfigurationFactory;

sub create{
    my ($actionconfig) = @_;
    my $flavour = $actionconfig->getFlavour();
    return undef if (! defined $flavour);
    if($flavour eq $gFlavourCockpit ){
        return LCM::Configuration::Cockpit::CockpitExternalActionConfigurationFactory->new($actionconfig);
    } else {
        return LCM::Configuration::EngineExternalActionConfigurationFactory->new($actionconfig,$flavour);
    }
}

sub getProductName{
    ...
}

sub getValidActions{
    ...
}

sub createSystemCollection{
    ...
}

sub createSelectedSystemsValuesBuilder{
    ...
}

1;