package LCM::Configuration::AddHostsCertifiedHostConfig;
 
use strict;
use parent qw ( LCM::Configuration::CertifiedHostConfig );
use SDB::Install::Configuration::AnyConfig;

sub setOriginHosts {
	my ($self, $originHosts) = @_;
	my $orderedHosts = [];
	my $localhost = $self->getLocalHanaHost();
	my $hostsParser = $self->getAddHostsParser();
	my $isLocalHostAdded = 0;
	foreach my $hostname(@$originHosts){
		if($hostname eq $localhost){
			$isLocalHostAdded = 1;
			next;
		}
		my $index = defined $hostsParser ? $hostsParser->getOrder($hostname) : -1 ;
		if($index > -1){
			splice(@$orderedHosts,$index,0,$hostname);	
		} else {
			push(@$orderedHosts,$hostname);
		}
	}
	if($isLocalHostAdded){
		unshift(@$orderedHosts,$localhost);
	}
	$self->{'params'}->{'CertificatesHostmap'}->{'origin_values'} = $orderedHosts;
}

1;