package LCM::Configuration::CertifiedHostConfig;

use strict;

use LCM::RegenerateCertificates;
use SAPDB::Install::Hostname;
use SDB::Install::System  qw ($hostname_regex $ipv4_regex);
use SDB::Install::Globals qw ($gOperationCollectHostInfo);
use LCM::Configuration::ParametersCreator;
our @ISA = qw (SDB::Install::Configuration);


sub new{
    my $self = shift->SUPER::new ();
    return $self;
}

sub getParamCertificatesHostmap {
    my ( $self, $order, $section ) = @_;
    my $paramCertificatesHostmap = LCM::Configuration::ParametersCreator::GetParamCertificatesHostmap( $order );
    
    $paramCertificatesHostmap->{'section'} = $section;
    $paramCertificatesHostmap->{'init_with_default'} = 1;
    $paramCertificatesHostmap->{'set_interactive'} = 1;

    return $paramCertificatesHostmap;
}

sub checkCertificatesHostmap {
    my ( $self, $hostname, $certificateHostname, $overwriteAlreadyDefined ) = @_;
    my $certificatesHostmapParam = $self->{params}->{CertificatesHostmap};
    my $certificatesHostmapValue = $certificatesHostmapParam->{value};
    my $lcHostname               = lc($hostname);
    my %originValues             = map { $_ => 1 } @{ $certificatesHostmapParam->{origin_values} };

    if ( !defined $originValues{$lcHostname} ) {
        $self->AddError("Host name '$hostname' is not part of the system");
        return 0;
    }

    if ( !$overwriteAlreadyDefined && defined $certificatesHostmapValue->{$lcHostname} ) {
        $self->PushError("Host name '$hostname' is already defined");
        return 0;
    }

    if ( $hostname !~ /$hostname_regex|$ipv4_regex/ ) {
        $self->PushError("'$hostname' is no valid host name or ipv4 address");
        return 0;
    }

    return 1;
}

sub setCertificatesHostmap {
    my ( $self, $hostname, $certificateHostname, $overwriteAlreadyDefined ) = @_;

    if ( !$self->checkCertificatesHostmap( $hostname, $certificateHostname, $overwriteAlreadyDefined ) ) {
        return 0;
    }
    if ($certificateHostname eq ""){
        $certificateHostname = undef;
    }    
    $self->{params}->{CertificatesHostmap}->{value}->{ lc($hostname) } = (defined $certificateHostname) ?  $certificateHostname : undef;
    return 1;
}

sub fillCertificatesHostmapDefaultValuesAndLocalData {
    my ($self, $useSHAOperation) = @_;
    $self->{'params'}->{'CertificatesHostmap'}->{'default_map'} = undef;
	$self->fillCertificatesHostmapDataForLocalHost($useSHAOperation);
    my $systemHosts      = $self->getSystemHosts();
	$self->setOriginHosts($systemHosts);
	$self->fillCertificatesHostmapDefaultValues();
    return 1;
}

sub setOriginHosts {
	my ($self, $originHosts) = @_;
	$self->{'params'}->{'CertificatesHostmap'}->{'origin_values'} = $originHosts;
}

# Origin hosts should also be set !
sub fillCertificatesHostmapDefaultValues {
	my ($self, $defaultValue) = @_;

	return if(!exists $self->{params}->{CertificatesHostmap});

	my $collectedValues = $self->{CertificatesHostmap};
	my $param = $self->{params}->{CertificatesHostmap};
	my $hosts = $self->{params}->{CertificatesHostmap}->{origin_values};

	return if(!defined $hosts);

	for my $host (@$hosts){
		next if ( defined $param->{default_map}->{$host} );
		my $value = (defined $defaultValue)? $defaultValue : $host;
		if( $collectedValues->{$host} ){
			$value = $collectedValues->{$host};
		}
		$param->{default_map}->{$host} = $value;
	}
}

sub fillCertificatesHostmapDataForLocalHost {
	my ($self) = @_;
	my $localhost = $self->getLocalHanaHost();
	my $localCertificateHostname;

	$localCertificateHostname = LCM::RegenerateCertificates::getCertOwner();
	$localCertificateHostname =~ s/CN=//;
	$self->{CertificatesHostmap}->{$localhost} = $localCertificateHostname;
}

1;
