package LCM::Configuration::Cockpit::CockpitStackSelectedSystemValuesBuilder;

use strict;
use warnings;
use parent qw(LCM::Configuration::SelectedSystemValuesBuilder);
use LCM::Utils::CommonUtils;

use SDB::Install::Globals qw($gProductNameCockpit $gProductNameEngine);

use constant INSTALL => ' (install)';

sub new{
    my($class,$config) = @_;
    my $self = bless{{},$class};
    $self->{config} = $config;
    return $self;
}

sub addInstall{
    my $self = shift;
    $self->addValidValue( "install"  );
    $self->addUiValue( "Install new $gProductNameCockpit system");
}

sub addHanaInstallations{
    my $self = shift;
    my $systemCollection = $self->getConfiguration()->getSystemCollection();
    my @installedHanaSystems = $systemCollection->getHanaInstallationsWithoutCockpit();
    foreach my $sid (@installedHanaSystems){
        $self->addValidValue($sid . INSTALL );
        my $uiValue = 'Install '.$gProductNameCockpit.' on '.$gProductNameEngine;
        my $sapsys = $systemCollection->getInstalledSystem($sid);
        $uiValue .=  ' version '.$sapsys->GetVersion();
        $self->addUiValue($uiValue. "\n" );
    }
}

sub addCockpitOnHanaInstallations{
    my $self = shift;
    my $systemCollection = $self->getConfiguration()->getSystemCollection();
    my @installedHanaSystems = $systemCollection->getHanaInstallationsWithCockpit();
    foreach my $sid (@installedHanaSystems){
        $self->addValidValue($sid . LCM::Configuration::SelectedSystemValuesBuilder::UPDATE );
        my $version = $systemCollection->getSystemVersion($sid);
        my $uiValue = 'Update '.$gProductNameCockpit.' version '.$version.' on '.$gProductNameEngine;
        my $sapsys = $systemCollection->getInstalledSystem($sid);
        $uiValue .=  ' version '.$sapsys->GetVersion();
        my $systemInfo =$systemCollection->getInstalledSystemInfo($sid);
        $uiValue .= $systemInfo ;
        $self->addUiValue($uiValue. "\n");
    }
}

sub initDefaultSystems {
    my ($self) = @_;
    $self->addInstalledSystems();
    $self->addCockpitOnHanaInstallations();
    if ( !defined $self->getConfiguration()->getValue('Action') || $self->getConfiguration()->getValue('Action') ne 'update' ) {
        $self->addPendingInstallations();
        $self->addLSSPendingInstallations();
        $self->addHanaInstallations();
        $self->addInstall();
    }
    $self->addExit();
}

1;