package LCM::Configuration::ComponentFsRootCustomInput;
use strict;

use base qw(Exporter);
use SDB::Install::Tools qw(askConfirmation);
use SDB::Common::BuiltIn;

our @EXPORT = qw(readInteractiveComponentRoot);

sub readInteractiveComponentRoot {
    my ($console, $config) = @_;
    my $componentRoot = getUserInput($config);
    return $componentRoot;
}

sub getUserInput {
    my ($config) = @_;
    my $componentRoot = '';
    my $builtIn = SDB::Common::BuiltIn->get_instance();
    while (1) {
        $config->resetError();
        my $paramStr = lc $config->getString('ComponentFsRoot');
        $builtIn->print("Enter $paramStr: ");
        chomp($componentRoot = <STDIN>);
        next if(!$componentRoot);

        last if($config->checkValue('ComponentFsRoot', $componentRoot));
        $builtIn->print($config->getErrorString()."\n\n");
        $config->getComponentManager()->resetRootComponents();
    }

    return $componentRoot;
}

1;
