package LCM::Configuration::ComponentValidation::LSSDependencyCheck;

use strict;
use SDB::Install::Globals qw($gKeynameEs $gProductNameLSS $gKeynameLSS);
use parent 'SDB::Install::Base';

sub check {
    my($self, $config) = @_;
    return 1 if(!$config->_isComponentAvailable($gKeynameLSS));

    my $es = $config->getComponentManager()->getComponentByKeyName($gKeynameEs);
    my $isEsSelected = defined $es && $es->isComponentSelected() ? 1 : 0;
    return $self->validateComponentLSSDependency($es) if($isEsSelected);

    my $systemComponentManager = $config->getSystemComponentManager();
    return 1 if(!defined $systemComponentManager);

    my $installedEs = $systemComponentManager->getComponentByKeyName($gKeynameEs);
    return $self->validateComponentLSSDependency($installedEs) if(defined $installedEs);

    return 1;
}

sub validateComponentLSSDependency {
    my($self, $component) = @_;
    my $rc = 1;
    if(!$component->isSupportedByLSS()){
        my $componentName = $component->getComponentName();
        $self->setErrorMessage("$componentName does not support $gProductNameLSS");
        $rc = 0;
    }
    return $rc;
}

1;