package LCM::Configuration::ContinueConfiguration;

use base qw(SDB::Install::Configuration::AnyConfig);

use SDB::Install::SysVars qw ($isWin);
use File::Spec;
use strict;

my %ACTION_TO_CONFIGURATION_MAPPING = (
	'configure_internal_network' => 'LCM::Configuration::InternalNetworkContinueConfiguration',
	'update_host' => 'LCM::Configuration::Hosts::UpdateHosts::UpdateLocalHostConfiguration'
);

sub InitDefaults{
	my ($self) = @_;
	
	return undef if(! $self->SUPER::InitDefaults() );
	
	my $hdbInstance = $self->getOwnInstance();
	
	$self->{hdbInstance} = $hdbInstance;
	my $persistenceFilePath = File::Spec->catfile($hdbInstance->get_hostNameDir(), $self->_getPersistenceFileName());
	$self->_setPersistenceFilePath($persistenceFilePath);
	$self->{localHostname} = $hdbInstance->get_host();
	my $action = $self->getAction();

	if($self->getAction() !~ 'configure_internal_network|update_host' ) {
		$self->getMsgLst()->addProgressMessage("Note: Selected action is not available!\n");
		return undef;
	}
	if(-f $self->{persistenceFilePath} && $action ne "update_host"){
	   $self->{parsedInformation} = $self->pers_load($self->{persistenceFilePath});
	}

    return undef if( ! $self->initParams() );
	
	return 1;
}

sub getPersistenceFilePath {
	my ($self) = @_;
	return $self->{persistenceFilePath};
}

sub _setPersistenceFilePath {
	my ($self, $filePath) = @_;
	$self->{persistenceFilePath} = $filePath;
}

sub _getPersistenceFileName {
	my ($self) = @_;
	return $self->{persistenceFileName};
}

sub _setPersistenceFileName {
	my ($self, $fileName) = @_;
	$self->{persistenceFileName} = $fileName;
}

sub initParams { return 1; }

sub getConfigureDialogs { return []; }

sub getStaticDialogs{ return []; }

sub deletePersistenceFileIfNeeded {
	my ($self) = @_;
	my $persistenceFilePath = $self->getPersistenceFilePath();
	if(defined($persistenceFilePath) && -f $persistenceFilePath){
        $self->getMsgLst()->addMessage("Deleting status file '$persistenceFilePath'.");
		if ( unlink($persistenceFilePath) ) {
            $self->getMsgLst()->addMessage("Status file '$persistenceFilePath' deleted.");
		} else {
			$self->getMsgLst()->addError("Status file '$persistenceFilePath' was not deleted.");
		}
	}
}

1;
