package LCM::Configuration::GenericStackSystemCollection;

use strict;
use warnings;
use parent qw(LCM::Configuration::BaseConfigurationSystemCollection);

sub getProductInfo {
    my ($self, $sapSys,$isPending) = @_;

    my $info   = '';
    if ($sapSys->hasNewDB()) {
        my $hosts = $sapSys->getNewDBInstances()->[0]->getAllHostsWithRoles(1);
        $info .= "\n" . join(', ', @$hosts) if ($hosts);
        my $pluginInstallations = $sapSys->getNewDBInstances()->[0]->getPluginInstallations();
        my @pluginKeys;
        if (defined $pluginInstallations){
            foreach my $inst (@$pluginInstallations){
                push @pluginKeys, $inst->getProductKey();
            }
            $info .= "\nplugins: " . join(', ', @pluginKeys) if (@pluginKeys);
        }
    }
    return $info;
}

1;