package LCM::Configuration::HdbLcmInstalledActionConfiguration;

use strict;

use base qw (LCM::Configuration::ActionConfiguration Exporter);
use SDB::Install::SAPSystem qw(CollectSAPSystems);
use LCM::DevelopmentTrace;
use LCM::ActionsDetector;
use LCM::Configuration::GenericStackAny qw($ini_section_general);


sub new {
	my $self  = shift->SUPER::new(@_);
	$self->_setValidActions();
	$self->_addAdditionalActionSwitches();
	my $order = scalar keys %{$self->{params}};
    $self->{params}->{'Action'}->{'f_init_interactive_values'} = sub {
    	$self->_setValidActionsWithExit();
    };
    $self->{params}->{'RemoteExecution'} = $self->getParamRemoteExecution($order++, $ini_section_general, 0);

	return $self;
}

sub _addAdditionalActionSwitches {
	my ($self) = @_;

	my $order = scalar keys %{$self->{params}};
	my $actionsDetector = $self->getActionsDetector();
	my $isSystemHost = $actionsDetector->isHostPartOfSystem();

	if ($isSystemHost) {
		$self->{params}->{'Uninstall'} = {
			'order'                 => $order++,
			'opt'                   => 'uninstall',
			'type'                  => 'boolean',
			'value'                 => undef,
			'default'               => 0,
			'set_interactive'       => 0,
			'init_with_default'     => 0,
			'str'                   => 'Uninstall system or components',
			'desc'                  => 'Uninstall system or components',
			'mandatory'             => 0,
			'excludeFromConfigDump' => 1,
			'action_switch'=> 1,
			'help_switch_usage' => '[--pass_through_help]'
		};
	}
}

sub _setValidActions {
	my ( $self, ) = @_;
    
	my $isGui = $self->{options}->{isGUI};
    my $actionsDetector = new LCM::ActionsDetector($self, $isGui);
    $self->_setActionsDetector($actionsDetector);

    my ($validActions, $validUiActions) = $actionsDetector->getValidActionsUIValues();
    $self->setValidActions( $validActions );
    $self->setActionUIValues( $validUiActions );
    
}

sub _setValidActionsWithExit {
	my ($self, ) = @_;
	
	return if ($self->{exit_initialized}); 
	
	my $validActions = $self->getValidActions();
	push (@$validActions, 'exit');
	$self->setValidActions($validActions);

	$validActions = $self->getActionUIValues();
	push (@$validActions, 'Exit (do nothing)');
	$self->setActionUIValues($validActions);
	
	$self->{exit_initialized} = 1;
}

sub checkAction {
	my ( $self, $action ) = @_;

	if ( $action eq "exit" ) {
		LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
		exit;
	}

	my $validActions = $self->getValidActions();

	return (grep {$_ eq $action} @$validActions);
}

sub checkUninstall {
	my ($self, $value) = @_;
	
	$self->setValue('Action', "uninstall");
	return 1;
}

sub setActionBatchValue {
    my ($self, ) = @_;
    #no default action for the resident hdblcm
}

sub isScopeInstance {
	my ($self, $fileName) = @_;
    my $persistenceFile = $self->getPersistenceFile($fileName);
    return defined($persistenceFile) && $self->pers_exists( $persistenceFile );
}

sub getPersistenceFile {
    my ($self, $fileName) = @_;

    require SDB::Install::Installer;
    my $installer = new SDB::Install::Installer();

    my $sapSys = $installer->getInstallation($self->getMsgLst());
    if ( defined $sapSys && $sapSys->isa( 'SDB::Install::SAPSystem' ) ) {
        if ( $sapSys->hasNewDB() ) {
            my $hdbInstance = $sapSys->getNewDBInstances()->[0];
            my $hostnameDir = $hdbInstance->get_hostNameDir();
            return File::Spec->catfile($hostnameDir, "$fileName");
        }
    }
    return undef;
}

sub hasPendingSlaveOperations {
	my ($self) = @_;
	my $result = $self->getPendingSlaveOperations();
	return keys(%{$result}) > 0;
}

sub getPendingSlaveOperations {
	my ($self) = @_;

	require SDB::Install::Installer;
	my $installer = new SDB::Install::Installer();

	my $sapSys = $installer->getInstallation($self->getMsgLst());
    
    return {} unless(defined $sapSys && $sapSys->isa('SDB::Install::SAPSystem'));
    return {} unless($sapSys->hasNewDB());

	my $result = {};
	my $hdbInstance = $sapSys->getNewDBInstances()->[0];
	my $hosts = $hdbInstance->get_allhosts();
	my $fileNames = ['hdblcm_configure_internal_network', 'hdblcm_rename_system', 'hdblcm_update_host'];
	my $instanceDir = $hdbInstance->get_instanceDir();
	
	for my $host( @{$hosts} ) {
		for my$fileName ( @{$fileNames} ) {
			if(-f File::Spec->catfile($instanceDir, "$host" ,"$fileName")){
				my $actionName = $fileName;
				$actionName =~ s/^hdblcm_//;
				$result->{$actionName} = [] if(!defined($result->{$actionName}));
				push(@{$result->{$actionName}}, $host); 
			}
		}
	}
    
    return $result;
}

sub getParamRemoteExecution;
* getParamRemoteExecution =
        \&SDB::Install::Configuration::AnyConfig::getParamRemoteExecution;

1;
