package LCM::Configuration::HdblcmExternalSelectedSystemValuesBuilder;

use strict;
use warnings;
use parent qw(LCM::Configuration::SelectedSystemValuesBuilder);

sub new{
    my($class,$config) = @_;
    my $self = bless{{},$class};
    $self->{config} = $config;
    return $self;
}

sub initDefaultSystems {
    my ($self) = @_;
    $self->addInstalledSystems();
    if ( !defined $self->getConfiguration()->getValue('Action') || $self->getConfiguration()->getValue('Action') ne 'update' ) {
        $self->addPendingInstallations();
        $self->addLSSPendingInstallations();
        $self->addInstall();

        if (!$self->getConfiguration()->isSimpleMode()) {
            $self->addValidValue( "extract_components");
            $self->addUiValue( 'Extract components');
            $self->addValidValue( "print_detected_components");
            $self->addUiValue( 'Print detected components');
        }
    }
    $self->addExit();
}

1;
