package LCM::Configuration::Hosts::AddHosts::AddRemoteHostsConfiguration;

use strict;


use SDB::Install::Configuration::NewServerConfig;
use SDB::Install::Configuration::HdbModify;
use SAPDB::Install::Hostname;
use SDB::Install::System qw (isAdmin isSidadmin);
use SDB::Install::SysVars qw ($isWin);
use SDB::Install::Configuration qw( $bool_true_pattern );

use base qw( LCM::Configuration::Hosts::AddHosts::AddHostsBaseConfiguration );

sub new {
	my $self = shift->SUPER::new(@_);
	$self->_initListenInterfaceValidValues();
	return $self;
}

sub checkUID {
	return 1;
}

sub addListeners {
    my $self = shift();
    $self->SUPER::addListeners(@_);
    $self->addParameterListener('AutoAddXS2Roles', sub {
        my ($value) = @_;
        if($value =~ /$bool_true_pattern/){
            my $hostToRoleMap = $self->getAutoAssignXs2RolesMap();
            my @hostsWithAdditionalRoles = grep { length($hostToRoleMap->{$_}) > 0 } keys(%{$hostToRoleMap});
            my $resultString = join(',', map { sprintf('Host: %s Role: %s', $_, $hostToRoleMap->{$_}) } @hostsWithAdditionalRoles);
            $self->{params}->{AutoAddXS2Roles}->{desc} = $resultString;
        }
        return 1;
    });
}

sub _initListenInterfaceValidValues{
	my ($self) = @_;
	my @listenInterfaceValidValues = qw( global internal );
	$self->{params}->{ListenInterface}->{valid_values} = \@listenInterfaceValidValues;
}

sub InitDefaults{
	my ($self, $kit) = @_;
	
	my $rc = $self->SUPER::InitDefaults($kit);

	if ($rc) {
		$self->setSkip('Password', 0);
		$self->_handleListenInterfaceParam();
		my $internalNetworkParameter = $self->{params}->{InternalNetwork};
		$internalNetworkParameter->{valid_values} = $internalNetworkParameter->{valid_values} || [];
	}

	return $rc;
}

sub updateInternalNetworkValidValues {
	my ($self, $interfaceType) = @_;
	$interfaceType = $interfaceType eq 'local' ? $self->getDefault('ListenInterface') : $interfaceType;
	$self->SUPER::updateInternalNetworkValidValues($interfaceType);
}

sub checkAddHosts {
	my ($self, $value) = (shift(), shift());
	
	if(!defined($value) || length($value) == 0){
		$self->PushError("There must be at least one host to proceed");
		return undef;
	}
	return $self->SUPER::checkAddHosts($value, @_);
}

sub _handleListenInterfaceParam{
	my ($self) = @_;
	
	my $instance = $self->getOwnInstance();
	my $listenInterface = $instance->getTrexNetListenInterface ();
	if ($listenInterface eq '.local'){
		$self->setDefault('ListenInterface', 'global');
		$self->updateInternalNetworkValidValues('global');
		$self->setDefault('InternalNetwork', 'none');
		$self->{params}->{'ListenInterface'}->{skip} = 0;
		$self->{params}->{'ListenInterface'}->{hidden} = 0;
		$self->{params}->{'InternalNetwork'}->{skip} = 0;
		$self->{params}->{'InternalNetwork'}->{hidden} = 0;
	} else {
    	$self->{params}->{'ListenInterface'}->{skip} = 1;
		$self->{params}->{'ListenInterface'}->{hidden} = 1;
		$self->{params}->{'InternalNetwork'}->{skip} = 1;
		$self->{params}->{'InternalNetwork'}->{hidden} = 1;
	}
}

sub getStaticDialogs{
	return ["LCM::Gui::Dialogs::SummaryDialog", "LCM::Gui::Dialogs::ConfigurationExecutionDialog", "LCM::Gui::Dialogs::FinalizeDialog"];
}

sub getConfigureDialogs {
	my ($self, $wizard) = @_;
	
	require LCM::Gui::Dialogs::AddHosts::AdditionalHostsPropertiesDialog;
	require LCM::Gui::Dialogs::SystemUserPropertiesDialog;
	require LCM::Gui::Dialogs::AddHosts::AcceleratorPropertiesDialog;
	require LCM::Gui::Dialogs::OrgManagerCredentialsDialog;
	require LCM::Gui::Dialogs::InternalNetworkPropertiesDialog;
	require LCM::Gui::Dialogs::AddHosts::CertificatesDialog;
	require LCM::Gui::Dialogs::HostagentPasswordDialog;
	
	return [
		new LCM::Gui::Dialogs::AddHosts::AdditionalHostsPropertiesDialog ($wizard),
		new LCM::Gui::Dialogs::SystemUserPropertiesDialog ($wizard),
		new LCM::Gui::Dialogs::AddHosts::AcceleratorPropertiesDialog ($wizard),
		new LCM::Gui::Dialogs::OrgManagerCredentialsDialog($wizard),
		new LCM::Gui::Dialogs::AddHosts::CertificatesDialog ($wizard),
	    $self->isSkipped("ListenInterface") ? () : new LCM::Gui::Dialogs::InternalNetworkPropertiesDialog ($wizard),
	    new LCM::Gui::Dialogs::HostagentPasswordDialog ($wizard),
    ];
}


sub getNumberOfExpectedOutputLines {
    return 50;
}

sub handleHostagentPassword {
my ($self,$hanldeRemoteHosts) = @_;

	$self->SUPER::handleHostagentPassword($hanldeRemoteHosts);

	my $isHostagentPasswordSkipped = $self->isSkipped('HostagentPassword') && $self->isSkipped('InitialHostagentPassword');

	my $installHostagentValue = (defined $self->getBatchValue("InstallHostagent")) ?
								$self->getBatchValue("InstallHostagent") : $self->getDefault("InstallHostagent");

	if ($isHostagentPasswordSkipped and $installHostagentValue) {
		# Executor provides option '--skip_hostagent_password=1' to hdbmodify
		$self->setValue('SkipHostagentPw', 1);
	}
}

sub getLocalHanaHost {
	my ($self) = @_;
	my $hostname;
	my $instance = $self->getOwnInstance();

	$hostname = $instance->get_host() if defined $instance;

	if (not defined $hostname) {
		$hostname = lc(hostname());
	}

	return $hostname;
}

# Explicitly ignore the value of $overwriteAlreadyDefined because it does not make any sense to disable overwrite
sub checkCertificatesHostmap {
    my ( $self, $hostname, $certificateHostname, $overwriteAlreadyDefined ) = @_;
	return $self->SUPER::checkCertificatesHostmap($hostname, $certificateHostname, 1);
}

sub verifySidAdmPassword {
	my ($self, undef, $password, $str) = @_;

	require LCM::Configuration::NewDBUser::User;

	my $sidAdmUsername = $self->getSysAdminUserName($self->getSID());
	my $sidadmUser = new LCM::Configuration::NewDBUser::User($sidAdmUsername);

	$sidadmUser->setVerifyOnAdditionalHosts(0);
	my $savedCtx = $sidadmUser->setMsgLstContext([$self->getMsgLst()]);
	my $rc = $sidadmUser->verifyPassword($password, $self);
	if (!defined $rc){
		$self->getMsgLst()->appendMsgLst ($sidadmUser->getErrMsgLst());
		$self->getMsgLst()->addMessage ("Ignoring error => password validation skipped.");
		return 1;
	}
	if($rc != 1 && !isSidadmin($self->getSID())) {
		$self->appendErrorMessage ('Unknown user password combination');
	}
	return $rc;
}

1;
