package LCM::Configuration::Hosts::AddHosts::Validators::LSS::InstallationPathCheck;

use strict;
use warnings;
use parent qw(LCM::Configuration::Hosts::AddHosts::Validators::LSS::BaseCheck);
use File::stat;
use SDB::Install::Globals qw($gHostRoleStandby $gHostRoleWorker $gShortProductNameLSS);
use SDB::Install::System::Mounts;

sub check {
    my($self, $hostNames) = @_;
    foreach my $host( @$hostNames ){
        if(!$self->checkHost($host)){
            return 0;
        }
    }
    return 1;
}

sub checkHost {
    my($self, $hostName) = @_;
    my $cfg = $self->getConfiguration();
    my $localHost = $cfg->getLocalHanaHost();
    if($localHost eq $hostName){
        return $self->_checkLocalHostNotPartOfTheSystem($hostName);
    } else {
        return $self->_existsLssPathOnHost($hostName)
    }
}

sub _existsLssPathOnHost {
    my($self,$host) = @_;
    my $cfg = $self->getConfiguration();
    return 1 if(!defined $cfg->{lssPathExistenceHostmap}); #CollectOtherHostInfo hasn't collected information yet

    if(!$cfg->{lssPathExistenceHostmap}->{$host}){
        $self->appendErrorMessage("$gShortProductNameLSS installation path is not mounted on '$host'");
        return 0;
    }
    return 1;
}

sub _getLssPathOnHost {
    my($self,$host) = @_;

}

sub _checkLocalHostNotPartOfTheSystem {
    my( $self, $hostName) = @_;
    my $cfg = $self->getConfiguration();
    my $lssInstance = $cfg->getLssInstance();
    my $sharedPath =  $lssInstance->getLssSharedDir();
    if(!$sharedPath){
        $self->appendErrorMessage("$gShortProductNameLSS installation path doesn't exist on '$hostName'");
        return 0;
    }
    my $mounts = SDB::Install::System::Mounts->new();
    my $rwMounts = $mounts->getMountsWithOption('rw');
    my @foundLssMountPoint = defined $rwMounts ? grep {$sharedPath =~ /$_->{mnt_dir}/} @$rwMounts : undef;
    if(!@foundLssMountPoint){
        $self->appendErrorMessage("$gShortProductNameLSS installation path is not mounted on '$hostName'");
        return 0;
    }
    return 1;
}

1;