package LCM::Configuration::Hosts::HostsConfigurationFactory;

use strict;

use LCM::HostsUtility qw( IsHostPartOfSystem);
use SDB::Install::SysVars qw( $isWin $path_separator );
use LCM::Installer;
use Cwd qw(realpath);

sub NewAddHostsConfiguration {
	my ($actionInstconfig, $options, $configfile) = @_;
	my $instconfig;
		
	if (IsHostPartOfSystem()) {
		require LCM::Configuration::Hosts::AddHosts::AddRemoteHostsConfiguration;
		$instconfig = new LCM::Configuration::Hosts::AddHosts::AddRemoteHostsConfiguration( $options, $configfile );
	} else {
		require LCM::Configuration::Hosts::AddHosts::AddLocalAndRemoteHostsConfiguration;
		$instconfig = new LCM::Configuration::Hosts::AddHosts::AddLocalAndRemoteHostsConfiguration( $options, $configfile );
	}
	
	my $installer = new LCM::Installer();
	my $sid = $installer->getSid();
	$instconfig->setDefault( 'SID', $sid );
	
	my $target = GetTarget();
	$instconfig->setDefault( 'Target', $target );
		
	return $instconfig;
}

sub GetTarget{
	my $installer = new LCM::Installer();
	my $target = myRealPath( $installer->getRuntimeDir() . (($path_separator . '..') x 3) );
	
	return $target;
}

sub myRealPathWin {
	my $path = realpath( $_[0] );
	$path =~ s/\//\\/g;
	return $path;
}

sub myRealPath;
*myRealPath = $isWin ? \&myRealPathWin : \&realpath;

1;
