package LCM::Configuration::InternalNetworkContinueConfiguration;

use base qw(LCM::Configuration::ContinueConfiguration);

use SDB::Install::SysVars qw ($isWin);
use LCM::Configuration::GenericStackAny;
use LCM::Configuration::InternalNetworkConfiguration;
use SDB::Install::System qw(isSidadmin);
use strict;

sub new {
	my $class = shift;
	my $self = $class->SUPER::new (@_);
	my $installer = new LCM::Installer ();
	my $sid       = $installer->getSid();
	
	$self->_setPersistenceFileName('hdblcm_configure_internal_network');
	
	@$self{qw( SID sidAdm )} = ($sid, $self->getSysAdminUserName($sid));
	my $sidAdmPasswordParam = $self->_getParamSidAdmPassword(0, $ini_section_general);
	
	$self->{params} = {
		'Password' => $sidAdmPasswordParam,
	};
	return $self;
}

sub getHdbregPath {
	my ($self) = @_;
	my $installDir = $self->{hdbInstance}->get_globalTrexInstallDir();
	return File::Spec->catfile($installDir, 'bin', 'hdbreg');
}

sub getSidAdm(){ return $_[0]->{sidAdm}; }

sub getProductName{ return "Inter-Service Communication Configuration"; }

sub getAction{ return "configure_internal_network"; }

sub InitDefaults{
    my $self = shift();
    if (isSidadmin()) {
        $self->PushError("Cannot continue 'Configure Inter-Service Communication' scenario when tool is started as system administrator. Start the tool as root user.");
        return 0;
    }    
    return $self->SUPER::InitDefaults(@_);
}

sub checkPassword {
    my ($self, $value) = @_;
    return $self->LCM::Configuration::InternalNetworkConfiguration::checkPassword($value);
}

sub createSummaryTree { return LCM::SummaryTreeBuilder::buildSummaryTree($_[0]); }

sub _getParamSidAdmPassword{
    my ($self, $order, $section) = @_;
    return $self->LCM::Configuration::InternalNetworkConfiguration::_getParamSidAdmPassword($order, $section);
}

1;