package LCM::Configuration::ParametersCreator;

use strict;
use SDB::Install::Globals qw( 	GetHostRoleProperties
                                $gProductName
								$gProductNameReferenceData
								$gOptionOptimizedExecutionMode
								$gOptionStandardExecutionMode
								$gShortProductNameXS2
								$gMandatoryXSComponents
                                $gEvenShorterProductNameXSA
                                $gProductNameCockpit
                                $gShortProductNameCockpit);

use Exporter;
use LCM::Configuration::ComponentFsRootCustomInput;

our @ISA = qw (Exporter);
our @EXPORT = qw (
    GetParamCertificatesHostmap
    getParamRolesHostmap
    GetParamAddLocalRoles
    getParamRemoveHostRoles
    GetParamVerifySignature
    GetParamUpdateProcess
    GetParamSelectedSystem
    GetParamComponentsRegistration
    GetParamDeploySHAConfigurations
    GetParamCertificateHostname
    GetParamUpdateComponentListLocation
    defineConstraintOfHanaOptionParam
    GetParamComponentArchivesPath
    GetParamExtractTempDir
    GetParamOverwriteExtractDir
    GetParamSapcarLocation
    GetParamTarExecutableLocation
    GetParamUnrarExecutableLocation
    GetParamSelectedXs2Applications
    GetParamAutoAddXS2Roles
    GetParamExistingHosts
    GetParamIgnore
    GetParamReferenceDataPath
    GetParamXSSpaceIsolation
    GetParamXSComponentsCfg
    GetParamXSSAPSpaceIsolation
    GetParamXSSpaceUserIdSAP
    GetParamXSSpaceUserIdProd
    GetParamXSComponentsNoStart
    GetParamXSCertPem
    GetParamXSCertKey
    GetParamXSTrustPem
    GetParamRemoveHosts
    GetParamUseMasterPassword
    GetParamMasterPassword
    GetParamHostsProperties
    GetParamUseSimpleUI
    GetParamSystemDBSQLPasswd
    GetParamSystemDBUseSingleDBUserPassword
    GetParamCockpitTenant
    GetParamCockpitXSSpace
    GetParamCockpitSpaceGUID
    GetParamKeepCockpitTenant
    GetParamXSTenantDatabaseName
    GetParamInstallXS2InDefaultTenant
    GetParamDvdPath
    GetParamComponentDirs
    GetParamComponentFsRoot
    GetParamAddComponentsLocation
);

our $validHostRoles = GetHostRoleProperties();

sub GetParamUseSimpleUI {
    my ($order, $section) = @_;

    return {
        'order'             => $order,
        'opt'               => 'simplified_ui',
        'opt_arg'           => '<true|false>',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'set_interactive'   => 0,
        'str'               => 'Use Simplified Installation UI',
        'desc'              => 'Use Simplified Installation UI',
        'mandatory'         => 0,
        'init_with_default' => 1,
        'skip'              => 0,
    };
}

sub GetParamIgnore {
	my ($order, $section, $ignoreValues) = @_;
	return {
		'order'                       => $order,
		'opt'                         => 'ignore',
		'type'                        => 'csv',
		'section'                     => $section,
		'value'                       => undef,
		'init_with_default'           => 0,
		'set_interactive'             => 0,
		'str'                         => 'Ignore',
		'mandatory'                   => 0,
		'valid_values'                => $ignoreValues,
		'ui_values'                   => $ignoreValues,
	};
}

sub GetParamExistingHosts {
	my ($order, $section) = @_;
	return {
		'order'             => $order,
		'opt'               => 'existing_hosts',
		'type'              => 'string',
		'section'           => $section,
		'value'             => undef,
		'init_with_default' => 0,
		'set_interactive'   => 0,
		'str'               => 'Existing Hosts',
		'mandatory'         => 0,
	};
}

sub GetParamUseMasterPassword {
	my ($order, $section, $constraint) = @_;
	my $string = 'Use single master password for all users, created during installation';

	return {
		'order'                   => $order,
		'opt'                     => 'use_master_password',
		'type'                    => 'boolean',
		'section'                 => $section,
		'value'                   => undef,
		'desc'                    => $string,
		'str'                     => $string,
		'default'                 => 0,
		'init_with_default'       => 1,
		'console_omit_word_Enter' => 1,
		'set_interactive'         => 0,
		'constraint'              => $constraint,
		'skip'                    => 0,
		'mandatory'               => 1,
	};
}

sub GetParamMasterPassword {
	my ($order, $section) = @_;
	return {
		'order'             => $order,
		'opt'               => 'master_password',
		'type'              => 'initial_passwd',
		'opt_arg'           => '<master_password>',
		'section'           => $section,
		'value'             => undef,
		'default'           => undef,
		'str'               => 'Master Password',
		'init_with_default' => 0,
		'log_value'         => sub {defined $_[0] ? '***' : '<not defined>';},
		'mandatory'         => 1,
		'skip'              => 1,
	};
}

sub GetParamXSSAPSpaceIsolation {
	my ($order, $section, $constraint) = @_;
	my $isGUI = LCM::App::ApplicationContext::getInstance()->getApplication()->isGUIApplication();
	my $suffix = $isGUI ? '' : ' (y/n)';
	my $string = 'Run Applications in SAP Space with Separate OS User' . $suffix;

	return {
		'order'						=> $order,
		'opt'						=> 'xs_sap_space_isolation',
		'type'						=> 'boolean',
		'section'					=> $section,
		'value'						=> undef,
		'desc'						=> 'Run Applications in SAP Space with Separate OS User',
		'str'						=> $string,
		'default'					=> 1,
		'init_with_default'			=> 1,
		'console_omit_word_Enter'	=> 1,
		'set_interactive'			=> 0,
		'constraint'				=> $constraint,
		'skip'						=> 0,
	};
}

sub GetParamXSSpaceIsolation {
	my ($order, $section, $constraint) = @_;
	my $isGUI = LCM::App::ApplicationContext::getInstance()->getApplication()->isGUIApplication();
	my $suffix = $isGUI ? '' : ' (y/n)';
	my $string = 'Run Applications in Customer Space with Separate OS User' . $suffix;

	return {
		'order'						=> $order,
		'opt'						=> 'xs_customer_space_isolation',
		'type'						=> 'boolean',
		'section'					=> $section,
		'value'						=> undef,
		'desc'						=> 'Run Applications in Customer Space with Separate OS User',
		'str'						=> $string,
		'default'					=> 1,
		'init_with_default'			=> 1,
		'console_omit_word_Enter'	=> 1,
		'set_interactive'			=> 1,
		'constraint'				=> $constraint,
		'skip'						=> 1,
	};
}

sub GetParamXSSpaceUserIdSAP {
	my ($order, $section, $constraint) = @_;
	my $option = 'xs_sap_space_user_id';
	my $string = 'XS Advanced SAP Space OS User ID';
	my $description = 'OS user ID used for running XS Advanced applications in SAP space';
	my $stringTemplate = 'XS Advanced SAP Space OS User (%s) ID';

	return _getParamOsUserId($order, $section, $constraint, $option, $string, $stringTemplate, $description);
}

sub GetParamXSSpaceUserIdProd {
	my ($order, $section, $constraint) = @_;
	my $option = 'xs_customer_space_user_id';
	my $string = 'XS Advanced Customer Space OS User ID';
	my $description = 'OS user ID used for running XS Advanced applications in customer space';
	my $stringTemplate = 'XS Advanced Customer Space OS User (%s) ID';

	return _getParamOsUserId($order, $section, $constraint, $option, $string, $stringTemplate, $description);
}

sub GetParamXSComponentsNoStart {
    my ($order, $section, $constraint) = @_;

    return {
        'order'             => $order,
        'opt_arg'           => 'all|none|<comp1>[,<comp2>]...',
        'opt_arg_switch'    => '<comp1>[,<comp2>]...',
        'opt'               => 'xs_components_nostart',
        'type'              => 'csv',
        'section'           => $section,
        'value'             => undef,
        'default'           => 'none',
        'str'               => 'Do not start the selected XS Advanced components after installation',
        'init_with_default' => 1,
        'set_interactive'   => 0,
        'help_with_default' => 1,
        'constraint'        => $constraint,
        'skip'              => 1,
    };
}

sub GetParamAutoAddXS2Roles {
	my ($order, $section, $constraint) = @_;
	my $string = 'Automatically assign XS Advanced Runtime roles to the hosts with database roles';
	my $isGUI = LCM::App::ApplicationContext::getInstance()->getApplication()->isGUIApplication();
	if ( ! $isGUI ) {
		$string .= " (y/n)";
	}
	return {
		'order'						=> $order,
		'opt'						=> 'autoadd_xs_roles',
		'hostctrl_opt'				=> 'AUTOADD_XS_ROLES',
		'type'						=> 'boolean',
		'section'					=> $section,
		'value'						=> undef,
		'str'						=> 'Automatic adding of xs roles?',
		'desc'						=> 'Adds xs roles automatically',
		'str'						=> $string,
		'default'					=> 1,
		'init_with_default'			=> 1,
		'console_omit_word_Enter'	=> 1,
		'set_interactive'			=> 1,
		'constraint'				=> $constraint,
	};

}

sub GetParamSelectedXs2Applications {
	my ($order, $section, $constraint) = @_;
	my $mandatoryXSComponents = join (',', @{$gMandatoryXSComponents});

	return {
		'order'                       => $order,
		'opt'                         => 'xs_components',
		'opt_arg'                     => 'all|<comp1>[,<comp2>]...',
		'opt_arg_switch'              => '<comp1>[,<comp2>]...',
		'type'                        => 'csv',
		'str'                         => 'XS Advanced Components',
		'desc'                        => "Specifies the components to be installed or updated in combination with $gShortProductNameXS2",
		'interactive_str'             => 'comma-separated list of the selected indices',
		'console_text'                => "Choose XS Advanced components to be installed or updated:\n",
		'section'                     => $section,
		'default'                     => $mandatoryXSComponents,
		'value'                       => undef,
		'set_interactive'             => 1,
		'skip'                        => 1,
		'mandatory'                   => 0,
		'help_with_default'           => 1,
		'interactive_index_selection' => 1,
		'leaveEmptyInConfigDump'      => 1,
		'init_batch_with_default'     => 1,
		'constraint'                  => $constraint,
	};
}

sub GetParamXSComponentsCfg {
    my ( $order, $section, $constraint) = @_;

    return {
            'order'                  => $order,
            'opt'                    => 'xs_components_cfg',
            'opt_arg'                => '<path>',
            'type'                   => 'path',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => 0,
            'init_with_default'      => 0,
            'skip'                   => 0,
            'str'                    => "XS Advanced Components Configurations",
            'desc'                   => "Path to directory, containing MTA extension descriptors",
            'mandatory'              => 0,
            'constraint'             => $constraint,
    };
}

sub GetParamXSCertPem {
    my ( $order, $section, $constraint) = @_;

    return {
            'order'                  => $order,
            'opt'                    => 'xs_cert_pem',
            'opt_arg'                => '<path (.pem)>',
            'type'                   => 'path',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => 0,
            'init_with_default'      => 0,
            'skip'                   => 0,
            'str'                    => "XS Advanced Certificate",
            'desc'                   => "The certificate to be used by XSA",
            'mandatory'              => 0,
            'constraint'             => $constraint,
    };
}

sub GetParamXSCertKey {
    my ( $order, $section, $constraint) = @_;

    return {
            'order'                  => $order,
            'opt'                    => 'xs_cert_key',
            'opt_arg'                => '<path (.key)>',
            'type'                   => 'path',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => 0,
            'init_with_default'      => 0,
            'skip'                   => 0,
            'str'                    => "XS Advanced Certificate Key",
            'desc'                   => "The key of the certificate to be used by XSA",
            'mandatory'              => 0,
            'constraint'             => $constraint,
    };
}

sub GetParamXSTrustPem {
    my ( $order, $section, $constraint) = @_;

    return {
            'order'                  => $order,
            'opt'                    => 'xs_trust_pem',
            'opt_arg'                => '<path (.pem)>',
            'type'                   => 'path',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => 0,
            'init_with_default'      => 0,
            'skip'                   => 0,
            'str'                    => "XS Advanced Trust Certificate",
            'desc'                   => "The trust certificate to be used by XSA",
            'mandatory'              => 0,
            'constraint'             => $constraint,
    };
}

sub GetParamCertificatesHostmap {
    my ( $order ) = @_;

    my %param = (
        'order'           => $order,
        'opt'             => 'certificates_hostmap',
        'short_opt'       => 'C',
        'opt_arg'         => '<hostName>=<certificateHostName>',
        'opt_arg_switch'  => '<hostName%s>=<certificateHostName%s>',
        'type'            => 'mapping_list',
        'origin_values'   => undef,
        'value'           => undef,
        'default_map'     => undef,
        'default'         => undef,
        'str'             => 'Certificate Host Names',
        'desc'            => 'Generate self-signed SSL certificates for SAP Host Agent',
        'additional_desc' => "Specify this option to generate self-signed SSL certificates for SAP Host Agent on specified hosts\n"
          . "e.g. -C hdb_host1=certificate_host1 -C hdb_host2=certificate_host2",
        'str_templ'         => 'Certificate Host Name For Host \'%s\'',
        'mandatory'         => 0,
        'constraint'        => undef,
        'summary_full_print' => 1,
    );
    return \%param;
}

sub GetParamRemoveHosts {
    my ($order, $section) = @_;

    my $optArg = '<hostname1>[,<hostname2>]...';

    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    return {
        'order' => $order,
        'opt'               => 'removehosts',
        'opt_arg'           => $optArg,
        'type'              => 'csv',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'str'               => 'Host Name',
        'interactive_index_selection' => 1,
        'interactive_str'             => 'comma-separated list of selected indices',
        'console_text'                => "Specify hosts to remove from $flavourProductName System\n",
        'ui_column_header' => "Host Roles",
        'desc'              => "Specifies hosts to remove from $flavourProductName System",
        'additional_desc'   => 'Hosts are removed before new hosts are added.',
        'init_with_default' => 0,
        'set_interactive'   => 0,
    };
}

sub getParamRemoveHostRoles {
    my ($self, $order, $section) = @_;
    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    my $desc = SDB::Install::Configuration::AnyMultiHostConfig::getHostRoleDescription($self,1);
    my $param = {
        'order'             => $order,
        'opt'               => 'remove_roles',
        'short_opt'         => 'R',
        'opt_arg'           => '<hostName>=<role>',
        'opt_arg_switch'    => '<hostName%s>=<role%s>',
        'type'              => 'mapping_list',
        'origin_values'     => undef,
        'value'             => undef,
        'default_map'       => undef,
        'default'           => undef,
        'section'           => $section,
        'str'               => 'Remove Host Roles',
        'str_templ'         => 'Role For Host \'%s\'',
        'mandatory'         => 0,
        'constraint'        => "Valid for roles of $flavourProductName Options only",
        'init_with_default' => 0,
        'summary_full_print'=> 1,
        'set_interactive'   => 0,
        'hidden'            => 0,
        'desc'              => 'Remove roles of existing hosts',
        'additional_desc'   => "Specify this option to remove roles on specified hosts\n"
                               . "e.g. -R hdb_host1=role1[,role2...] -R hdb_host2=role2\n",
    };

    return $param;
}

sub getParamRolesHostmap{
    my ( $self, $order, $section, $constraint ) = @_;

	my $desc = SDB::Install::Configuration::AnyMultiHostConfig::getHostRoleDescription($self,1);
    my $param = {
	    'order'             => $order,
        'opt'               => 'add_roles',
        'short_opt'         => 'R',
        'opt_arg'           => '<hostName>=<role>',
        'opt_arg_switch'    => '<hostName%s>=<role%s>',
        'type'              => 'mapping_list',
        'origin_values'     => undef,
        'value'             => undef,
        'default_map'       => undef,
        'default'           => undef,
        'section'           => $section,
        'str'               => 'Additional Host Roles',
        'desc'              => 'Add roles to existing hosts',
        'additional_desc'   => "Specify this option to add roles on specified hosts\n"
                               . "e.g. -R hdb_host1=role1[,role2...] -R hdb_host2=role2\n"
                               . $desc,
        'str_templ'         => 'Role For Host \'%s\'',
        'mandatory'         => 0,
        'constraint'        => $constraint,
        'init_with_default' => 0,
        'summary_full_print'=> 1,
        'set_interactive'   => 0,
        'hidden'            => 0
    };
    
    return $param;
}

sub GetParamAddLocalRoles{
    my ( $self, $order, $section, $constraint ) = @_;
	
    my $sortedRoles = SDB::Install::Configuration::AnyMultiHostConfig::getSortedHostRoleNames(1);
    my @sortedRoleUIValues;
    foreach my $role (@$sortedRoles) {
        push @sortedRoleUIValues, $validHostRoles->{$role}->{str};
    }

	my $desc = SDB::Install::Configuration::AnyMultiHostConfig::getHostRoleDescription($self, 1);
    my $param = {
	        'order'           => $order,
	        'opt'             => 'add_local_roles',
	        'opt_arg'         => '<role1>[,<role2>]...',
	        'type'            => 'csv',
	        'section'         => $section,
	        'value'           => undef,
	        'default'         => undef,
	        'str'             => 'Additional Local Host Roles',
	        'desc'            => 'Specifies the roles of the local host',
            'additional_desc' => $desc,
            'constraint'      => $constraint,
            'valid_values'    => $sortedRoles,
            'ui_values'       => \@sortedRoleUIValues,
	        'set_interactive' => 0,
	        'hidden'          => 0
    };

    return $param;
}

sub GetParamExecutionMode {
	my ($order, $section, $skip, $action) = @_;
    $action //= 'update';
    my $capitalizedAction = ucfirst($action);

	return {
		'order' => $order,
		'opt' => "${action}_execution_mode",
		'type' => 'string',
		'section' => $section,
		'value' => undef,
		'default' => $gOptionStandardExecutionMode,
		'valid_values' => [ $gOptionStandardExecutionMode, $gOptionOptimizedExecutionMode ],
		'ui_values' => [ "$capitalizedAction components in sequence", "$capitalizedAction components with minimized system restarts" ],
		'str' => "$capitalizedAction Execution Mode",
		'desc' => "Specifies the $action execution workflow",
		'skip' => $skip,
		'init_with_default' => 1,
		'set_interactive' => 0,
	};
}

sub GetParamHostsProperties {
	my ($order, $section) = @_;

	my $param = {
		'order'	=> $order,
		'str' => 'Hosts Properties',
		'type' => 'string',
		'section' => $section,
		'csv_hostnames' => undef,
		'default' => undef,
		'set_interactive' => 0,
		'skip' => 1,
		'hidden' => 1,
		'custom_input' => undef
	};
}

sub GetParamSelectedSystem {
    my ( $order, $section ) = @_;
    my %param = (
        'order'                       => $order,
        'type'                        => 'string',
        'section'                     => $section,
        'value'                       => undef,
        'default'                     => "Exit (do nothing)",
        'set_interactive'             => 1,
        'str'                         => 'Action',
        'mandatory'                   => 0,
        'help_with_default'           => 1,
        'interactive_index_selection' => 1,
        'desc'                        => 'Selected action',
        'interactive_str'             => 'selected action index',
        'console_text'                => "Choose an action\n",
        'skip'                        => 0,
        'hidden'                      => 1,
    );
    return \%param;
}

sub GetParamComponentsRegistration {
	my ($order, $section, $isSkipped) = @_;
	return {
		'order'                  => $order,
		'opt'                    => 'components_registration',
        'opt_arg'    	 		 => '<register|unregister|none>',
		'type'                   => 'string',
		'section'                => $section,
        'valid_values'	   		 => ['register', 'unregister', 'none'],
		'value'                  => undef,
		'default'                => 'register',
		'set_interactive'        => 0,
		'str'                    => 'Components Registration',
		'desc'                   => "Specify components registration action : 'register', 'unregister' or 'none'",
		'mandatory'              => 1,
		'init_with_default'      => 1,
		'skip'					 => $isSkipped
	};
}

sub GetParamCertificateHostname {
	my ($order, $section, $isSkipped) = @_;
	return {
		'order'                  => $order,
		'opt'                    => 'certificate_hostname',
        'opt_arg'    	 		 => '<certificate_hostname>',
		'type'                   => 'string',
		'section'                => $section,
		'value'                  => undef,
		'set_interactive'        => 0,
		'str'                    => 'Certificate Host Name For The Local Host',
		'desc'                   => 'Generate self-signed SSL certificate for the SAP Host Agent on the localhost',
		'mandatory'              => 0,
		'skip'					 => $isSkipped
	};
}

sub GetParamUpdateComponentListLocation {
	my ($order, $section, $isSkipped) = @_;
	return {
		'order'                  => $order,
		'opt'                    => 'update_component_list_location',
		'opt_arg'                => '<true|false>',
		'type'                   => 'boolean',
		'section'                => $section,
		'value'                  => undef,
		'default'                => 1,
		'set_interactive'        => 0,
		'str'                    => 'Update Component List Location (used by SLD Data Supplier)',
		'desc'                   => 'Update component list location (used by SLD Data Supplier)',
		'mandatory'              => 0,
		'init_with_default'      => 1,
		'skip'					 => $isSkipped
	};
}

sub GetParamDeploySHAConfigurations {
	my ($order, $section, $isSkipped) = @_;
	return {
		'order'                  => $order,
		'opt'                    => 'deploy_sha_configurations',
		'opt_arg'                => '<true|false>',
		'type'                   => 'boolean',
		'section'                => $section,
		'value'                  => undef,
		'default'                => 1,
		'set_interactive'        => 0,
		'str'                    => 'Deploy Configurations to The SAP Host Agent',
		'desc'                   => 'Deploy configurations to the SAP Host Agent',
		'mandatory'              => 0,
		'init_with_default'      => 1,
		'skip'					 => $isSkipped
	};
}

sub GetParamReferenceDataPath {
    my ( $order, $section ) = @_;

    return {
        'order'				=> $order,
        'opt'				=> 'reference_data_path',
        'type'				=> 'path',
        'section'			=> $section,
        'value'				=> undef,
        'default'			=> undef,
        'set_interactive'	=> 1,
        'str'				=> "Installation Path for Address Directories and $gProductNameReferenceData",
        'desc'				=> "Installation Path for Address Directories and $gProductNameReferenceData",
        'constraint'        => "Valid for Installation of Address Directories and $gProductNameReferenceData only",
        'skip'				=> 1,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

# Parameters for ExtractComponentsConfiguration
sub GetParamComponentArchivesPath {
    my ($order, $section ) = @_;

    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    return {
        'order'                  => $order,
        'opt'                    => 'component_archives_dir',
        'type'                   => 'path',
        'section'                => $section,
        'value'                  => undef,
        'default'                => undef,
        'set_interactive'        => 1,
        'str'                    => "Location of $flavourProductName Component Archives",
        'desc'                   => "Location of $flavourProductName Component Archives",
        'leaveEmptyInConfigDump' => 1,
        'mandatory'              => 1
    };
}

sub GetParamExtractTempDir {
    my ($order, $section ) = @_;

    return {
        'order'                  => $order,
        'opt'                    => 'extract_temp_dir',
        'type'                   => 'path',
        'section'                => $section,
        'value'                  => undef,
        'default'                => undef,
        'set_interactive'        => 1,
        'str'                    => "Temporary Extract Directory",
        'desc'                   => "Temporary Extract Directory",
        'leaveEmptyInConfigDump' => 1,
        'mandatory'              => 1,
        'init_with_default'      => 1,
    };
}

sub GetParamOverwriteExtractDir {
    my ($order, $section, $str) = @_;

    $str //= "Overwrite Existing Files in the Extraction Directory";
    return {
        'order'                   => $order,
        'opt'                     => 'overwrite_extract_dir',
        'opt_arg'                 => '<true|false>',
        'type'                    => 'boolean',
        'section'                 => $section,
        'value'                   => undef,
        'default'                 => 0,
        'set_interactive'         => 1,
        'str'                     => "$str",
        'str_templ'               => "$str '%s'",
        'desc'                    => "$str",
        'init_with_default'       => 1,
        'leaveEmptyInConfigDump'  => 1,
        'console_omit_word_Enter' => 1,
    };
}

sub GetParamSapcarLocation {
    my ($order, $section ) = @_;

    return {
        'order'             => $order,
        'opt'               => 'sapcar_location',
        'type'              => 'path',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'set_interactive'   => 0,
        'str'               => "Location of 'SAPCAR' Executable",
        'desc'              => "Location of 'SAPCAR' Executable",
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub GetParamTarExecutableLocation {
    my ($order, $section) = @_;

    return {
        'order'             => $order,
        'opt'               => 'tar_executable_location',
        'type'              => 'path',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'set_interactive'   => 0,
        'str'               => "Location of 'tar' Executable",
        'desc'              => "Location of 'tar' Executable",
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub GetParamUnrarExecutableLocation {
    my ($order, $section) = @_;

    return {
        'order'             => $order,
        'opt'               => 'unrar_executable_location',
        'type'              => 'path',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'set_interactive'   => 0,
        'str'               => "Location of 'unrar' Executable",
        'desc'              => "Location of 'unrar' Executable",
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}
# End of parameters for ExtractComponentsConfiguration

sub getParamNoStartTenantDB{
    my ($self, $order, $section, $descStr, $hidden, $constraint) = @_;
    return {
        'order'                     => $order,
        'opt'                       => 'nostart_tenant_db',
        'hostctrl_opt'              => 'NOSTART_TENANT_DB',
        'type'                      => 'boolean',
        'section'                   => $section,
        'value'                     => undef,
        'default'                   => 0,
        'str'                       => 'Does not start tenant database after reconfiguration',
        'console_omit_word_Enter'   => 1,
        'init_with_default'         => 1,
        'set_interactive'           => 0,
        'hidden'                    => $hidden,
        'constraint'                => $constraint,
    };
}

sub defineConstraintOfHanaOptionParam {
    my ( $param, $productName ) = @_;
    $param->{'constraint'} = "Valid for Installation of $productName only";

    return $param;
}

sub _getParamOsUserId {
	my ($order, $section, $constraint, $option, $string, $stringTemplate, $description) = @_;
	return {
		'order'				=> $order,
		'opt'				=> $option,
		'type'				=> 'number',
		'opt_arg'			=> '<uid>',
		'section'			=> $section,
		'value'				=> undef,
		'default'			=> undef,
		'str'				=> $string,
		'str_templ'			=> $stringTemplate,
		'desc'				=> $description,
		'init_with_default'	=> 1,
		'set_interactive'	=> 1,
		'constraint'		=> $constraint,
		'mandatory'			=> 1,
		'skip'				=> 1,
	};
}

sub GetParamSystemDBSQLPasswd{
    my ($order,
        $section,
        $type,
        $skip, 
        $username,
        $constraint,
        $user_paramId
       ) = @_;

    my $isSkip = (defined $skip) ? $skip : 0;

    my $param = {
        'order'             => $order,
        'opt'               => 'systemdb_system_user_password',
        'type'              => $type,
        'opt_arg'           => '<database_password>',
        'section'           => $section,
        'value'             => undef,
        'default'           => undef,
        'str'               => 'System database user password',
        'str_templ'         => 'System database user (%s) password',
        'init_with_default' => 0,
        'log_value'         => sub {defined $_[0] ? '***' : '<not defined>';},
        'mandatory'         => 1,
        'skip'              => $isSkip,
        'constraint'        => $constraint,
        'retry_count'       => 3,
        'optional_password' => 1,
        'user_paramid'      => $user_paramId
    };
    if (defined $username) {
        $param->{str} = sprintf($param->{str_templ}, $username);
    }
    return $param
}

sub GetParamSystemDBUseSingleDBUserPassword {
    my ($order, $section, $constraint) = @_;

    return {
        'order'             => $order,
        'opt'               => 'systemdb_use_singledb_user_password',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'str'               => 'Use single DB user password for system database user',
        'init_with_default' => 0,
        'set_interactive'   => 0,
        'help_with_default' => 1,
        'constraint'        => $constraint,
        'skip'              => 0,
    };
}

sub GetParamVerifySignature {
    my ($order, $section) = @_;
    return {
        'order'             => $order,
        'opt'               => 'verify_signature',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'set_interactive'   => 0,
        'str'               => "Verify the authenticity of $gProductName components",
        'desc'              => "Verifies the authenticity of $gProductName components",
        'skip'              => 0,
        'mandatory'         => 1,
        'init_with_default' => 1,
    };
}

sub GetParamBootstrapFromResident {
    my ($order, $section) = @_;
    return {
        'order'             => $order,
        'opt'               => 'bootstrap',
        'type'              => 'boolean',
        'section'           => $section,
        'value'             => undef,
        'default'           => 0,
        'set_interactive'   => 0,
        'hidden'            => 1,
        'skip'              => 0,
        'mandatory'         => 0,
        'init_with_default' => 1,
    };
}

sub GetParamCockpitTenant {
    my ($order, $section, $constraint) = @_;
    return {
        'order'             => $order,
        'opt'               => 'cockpit_tenant',
        'type'              => 'string',
        'default'           => 'COCKPITDB',
        'init_with_default' => 1,
        'section'           => $section,
        'str'               => "$gShortProductNameCockpit Tenant Database Name",
        'desc'              => "The name of the tenant database, which is used for the $gProductNameCockpit installation",
        'skip'              => 1,
        'mandatory'         => 1,
        'set_interactive'   => 1,
        'constraint'        => $constraint,
    };
}

sub GetParamCockpitXSSpace {
    my ($order, $section, $constraint, $userParamId) = @_;
    return {
        'order' => $order,
        'opt' => 'cockpit_space',
        'type' => 'string',
        'section' => $section,
        'default' => 'COCKPIT',
        'str' => "$gEvenShorterProductNameXSA Space for $gShortProductNameCockpit",
        'desc' => 'The XSA space, which will be mapped to the cockpit tenant',
        'skip' => 1,
        'mandatory' => 1,
        'init_with_default' => 1,
        'set_interactive' => 1,
        'constraint' => $constraint,
    };
}

sub GetParamCockpitSpaceGUID {
    my ($order, $section, $constraint) = @_;
    return {
        'order'             => $order,
        'type'              => 'string',
        'section'           => $section,
        'init_with_default' => 1,
        'str'               => "The GUID of the $gEvenShorterProductNameXSA Space for $gShortProductNameCockpit",
        'desc'              => 'The GUID of the XSA space, which will be mapped to the cockpit tenant',
        'skip'              => 1,
        'mandatory'         => 0,
        'set_interactive'   => 0,
        'hidden'            => 1,
        'constraint'        => $constraint,
    };
}

sub GetParamKeepCockpitTenant {
    my ($order, $section, $constraint) = @_;
    return {
        'order'                     => $order,
        'opt'                       => 'keep_cockpit_tenant',
        'str'                       => "Keep the $gShortProductNameCockpit Tenant Database",
        'str_templ'                 => "Keep the $gShortProductNameCockpit Tenant Database (%s)",
        'desc'                      => "If set to true, the tenant database, where the $gShortProductNameCockpit resides, will be kept",
        'type'                      => 'boolean',
        'section'                   => $section,
        'constraint'                => $constraint,
        'default'                   => 0,
        'set_interactive'           => 1,
        'skip'                      => 1,
        'mandatory'                 => 1,
        'init_with_default'         => 1,
        'console_omit_word_Enter'   => 1,
    };
}

sub GetParamXSTenantDatabaseName {
    my ($order, $section, $constraint) = @_;
    return {
        'order'             => $order,
        'type'              => 'string',
        'str'               => "$gEvenShorterProductNameXSA Database",
        'desc'              => "The tenant database in which the $gShortProductNameXS2 is installed",
        'opt'               => 'xs_runtime_db_tenant',
        'opt_arg'           => '<tenant name or SYSTEMDB>',
        'default'           => 'SYSTEMDB',
        'init_with_default' => 1,
        'section'           => $section,
        'constraint'        => $constraint,
        'set_interactive'   => 1,
        'skip'              => 1,
        'mandatory'         => 1,
        'hidden'            => 1,
        'interactive_index_selection' => 1,
        'valid_values'      => ['SYSTEMDB'],
        'header_str'        => 'Database Name',
    };
}

sub GetParamInstallXS2InDefaultTenant {
    my ($order, $section, $constraint) = @_;
    my $isCLI = LCM::App::ApplicationContext::getInstance()->isCLI();
	my $suffix = $isCLI ? '? (y/n)' : '';
    return {
        'order'                     => $order,
        'type'                      => 'boolean',
        'str'                       => "Install $gEvenShorterProductNameXSA in the default tenant database".$suffix,
        'desc'                      => "Install $gEvenShorterProductNameXSA in the default tenant database",
        'opt'                       => 'xs_use_default_tenant',
        'section'                   => $section,
        'constraint'                => $constraint,
        'set_interactive'           => 1,
        'skip'                      => 1,
        'mandatory'                 => 0,
        'hidden'                    => 0,
        'default'                   => 0,
        'init_with_default'         => 1,
        'console_omit_word_Enter'   => 1,
    };
}

sub GetParamAddComponentsLocation {
    my ($order, $section) = @_;
    return {
        'order'                     => $order,
        'type'                      => 'boolean',
        'section'                   => $section,
        'str'                       => 'Do you want to specify additional components location? (y/n)',
        'opt'                       => 'add_components_location',
        'value'                     => undef,
        'default'                   => 0,
        'init_with_default'         => 0,
        'mandatory'                 => 0,
        'hidden'                    => 1,
        'set_interactive'           => 1,
        'console_omit_word_Enter'   => 1,
    };
}

sub GetParamComponentFsRoot {
    my ($order, $section, $isInteractive) = @_;
    $isInteractive //= 0;
    my %param = (
            'order'                  => $order,
            'opt'                    => 'component_root',
            'opt_arg'                => '<path>',
            'type'                   => 'path',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => $isInteractive,
            'str'                    => 'Directory root to search for components',
            'desc'                   => 'Directory including sub-directories to search for components',
            'leaveEmptyInConfigDump' => 1,
            'mandatory'              => 0,
            'custom_input'           => \&LCM::Configuration::ComponentFsRootCustomInput::readInteractiveComponentRoot
    );

    return \%param;
}

sub GetParamComponentDirs {
    my ($order, $section) = @_;

    my %param = (
            'order'                  => $order,
            'opt'                    => 'component_dirs',
            'opt_arg'                => '<path1>[,<path2>]...',
            'type'                   => 'string',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => 0,
            'str'                    => 'Comma separated list of component directories',
            'desc'                   => 'Component directories',
            'leaveEmptyInConfigDump' => 1,
            'mandatory'              => 0
    );

    return \%param;
}

sub GetParamDvdPath {
    my ($order, $section, $flavourProductName) = @_;
    my $str = defined $flavourProductName ?  "Location of $flavourProductName Installation Medium" :
        'Location of Installation Medium';
    my %param = (
            'order'                  => $order,
            'opt'                    => 'component_medium',
            'alias_opts'             => ['dvdpath'],
            'type'                   => 'path',
            'section'                => $section,
            'value'                  => undef,
            'default'                => undef,
            'set_interactive'        => 0,
            'str'                    => $str,
            'leaveEmptyInConfigDump' => 1,
            'mandatory'              => 0
    );

    return \%param;
}


1;
