package LCM::Configuration::Streaming::StreamingConfiguration;

use base qw(LCM::Configuration::GenericStackAny);
use SDB::Install::Globals qw ($gProductNameStreaming);
use LCM::Configuration::ParametersCreator qw ( defineConstraintOfHanaOptionParam );
use LCM::FileUtils;
use strict;

our $section = 'streaming';

sub getParamStreamingClusterManagerPassword{
    my ($self, $order) = @_;
    return {
        'order'   => $order,
        'opt'     => 'streaming_cluster_manager_password',
        'type'    => 'initial_passwd',
        'section' => $section,
        'value'   => undef,
        'default' => undef,
        'str'     => 'Streaming Cluster Manager Password',
        'desc'    => "Required for $gProductNameStreaming (new installation)",
        'skip'    => 1,
        'init_with_default' => 0,
        'set_interactive'   => 1,
        'mandatory'         => 1
    };
}

sub getParamBasepathStreaming{
    my ($self, $order) = @_;
    return {
        'order'   => $order,
        'opt'     => 'basepath_streaming',
        'type'    => 'path',
        'opt_arg' => '<path>',
        'section' => $section,
        'value'   => undef,
        'default' => '/hana/data_streaming/$SID',
        'str'     => 'Location of Streaming logstores and runtime information',
        'desc'    => "Location of Streaming logstores and runtime information",
        'skip'    => 1,
        'init_with_default' => 1,
        'set_interactive'   => 1,
        'mandatory'         => 1
    };
}

sub defineStreamingParams{
    my ($self) = @_;
    if (defined $self->{streamingParamsDefined}){
        return 1;
    }

    $self->{streamingParamsDefined} = 1;
    my $order = scalar keys %{ $self->{params} };
    $self->{paramIds} = undef;    # reset ordered id list cache

    my $streamingParams = {
       'StreamingClusterManagerPassword'  => defineConstraintOfHanaOptionParam($self->getParamStreamingClusterManagerPassword ($order++), $gProductNameStreaming),
       'BasepathStreaming'  			  => defineConstraintOfHanaOptionParam($self->getParamBasepathStreaming ($order++), $gProductNameStreaming),
    };
    map { $self->{params}->{$_} = $streamingParams->{$_} } keys %$streamingParams;
}

sub enableStreamingParamsIfNeeded {
    my ($self) = @_;
    my $isNewInstall = $self->isStreamingNewInstall();
    my $autoInitializeServices = $self->getValue('AutoInitializeServices');
    my $isCompatiblityModeWithAutoInit = ($self->isSystemInCompatibilityMode && $autoInitializeServices);
    my $shouldSkipPassword = (!$isNewInstall || (!$self->_isSingleDB && !$isCompatiblityModeWithAutoInit)) ? 1 : 0;
    my $shouldSkipBasePath = (!$isNewInstall) ? 1 : 0;

    $self->setSkip('StreamingClusterManagerPassword', $shouldSkipPassword);
    $self->setSkip('BasepathStreaming', $shouldSkipBasePath);

    return 1;
}

sub _isSingleDB {
    my ($self) = @_;
    my $ownInstance = $self->getOwnInstance();
    my $userInputDbMode = $self->getValue('DbMode') || 'singledb';
    my $dbMode = defined($ownInstance) ? $ownInstance->getDbMode() : 'singledb';

    return ($dbMode eq 'singledb') && ($userInputDbMode eq 'singledb');
}

sub checkBasepathStreaming {
    return $_[0]->checkHanaOptionsPathParam('BasepathStreaming', $_[1]);
}

sub checkPasswordLength{
    my ($self, $passwordDesc, $password) = @_;
    if (length ($password) < 6){
        $self->setErrorMessage ("'$passwordDesc' is invalid. The password must have at least 6 characters.");
        return undef;
    }
    return 1;
}

sub checkStreamingClusterManagerPassword {
    my ($self, $password) = @_;

    my $msglst = new SDB::Install::MsgLst ();
    my $rc;
    if (defined $self->getOwnInstance()) {
        $rc = $self->complySqlPasswordPolicy ($password, 0, $msglst, 'StreamingClusterManagerPassword');
    } else {
        $rc = $self->complyDefaultSqlPasswordPolicy ($password, $msglst, 'StreamingClusterManagerPassword');
    }
    if (!$rc){
        my $paramName = $self->{params}->{StreamingClusterManagerPassword}->{str};
        $self->PushError ("$paramName is invalid", $msglst);
    }
    return $rc;
}

sub isStreamingUpdate{
    my ($self) = @_;
    my $streamingComponent = $self->{componentManager}->getComponentByBatchKey("streaming");
    if (defined $streamingComponent && $streamingComponent->isComponentSelected() && $streamingComponent->isUpdate){
        return 1;
    }
    return 0;
}

sub isStreamingNewInstall{
    my ($self) = @_;
    my $streamingComponent = $self->{componentManager}->getComponentByBatchKey("streaming");
    if (defined $streamingComponent && $streamingComponent->isComponentSelected() && !$streamingComponent->isUpdate){
        return 1;
    }
    return 0;
}

1;
