package LCM::Configuration::UpdateComponentListConfiguration;

use strict;
use SDB::Install::SysVars;
use LCM::Installer;
use SDB::Install::Configuration::AnyConfig;
use SDB::Install::System qw (getSysProgPath);
use SDB::Install::Globals qw($gProductNameEngine);

our $progpath = $isWin || $isApple ? getSysProgPath () : '/usr';

our @ISA = qw (LCM::Configuration::GenericStackAny SDB::Install::Configuration::AnyConfig);

sub UPDATE_COMPONENT_LIST_ACTION {"update_component_list"};

sub new{
    my $self = shift->SUPER::new (@_);
    $self->{params} = {};

	if (!$self->initialize()) {
		return undef;
	}
	
    return $self;
}

sub InitDefaults{
	return 1;
}

sub initialize {
	my $self = shift;
	my $installer = new LCM::Installer();
	$installer->setMsgLstContext([$self->getMsgLst()]);
	my $scm = $installer->getOwnSystemComponentManager();
	$self->{systemComponentManager} = $scm;
	if (!defined $scm){
		$self->setErrorMessage("Cannot determine the installed '$gProductNameEngine'. Start the tool from its original location inside the database.");
		return undef;
	}
	
	return 1;
}

sub getSID {
	return $_[0]->{systemComponentManager}->getSid();
}

sub getSystemComponentManager {
	return $_[0]->{systemComponentManager};
}

sub getProductName{
    my $flavourProductName = LCM::App::ApplicationContext::getFlavourProductName();
    return $flavourProductName. " Components";
}

sub getAction{
	return UPDATE_COMPONENT_LIST_ACTION;
}

1;
