package LCM::Configuration::UpdateSystemBootstrapConfiguration;

use strict;
use parent qw(SDB::Install::Configuration::AnyConfig LCM::Configuration::GenericStackConfiguration);
use LCM::Configuration::GenericStackAny qw($ini_section_general $ini_section_server);
use LCM::Configuration::ParametersCreator qw(GetParamVerifySignature GetParamDvdPath GetParamComponentDirs GetParamComponentFsRoot);
use LCM::Configuration::GenericStackUpdateConfiguration;
use LCM::Configuration::ValueChangeListeners::Update::UpdateSystemBootstrapComponentListener;
use LCM::Configuration::ValueChangeListeners::Update::ServerDetectionListener;
use LCM::ComponentManager::ComponentScanner;
use LCM::Configuration::ValueChangeListeners::SignatureVerificationListenerFactory;
use LCM::Manifests::ResidentInstallerManifest;
use LCM::ComponentManager::UpdateSystemBootstrapComponentManager;
use SDB::Install::Globals qw($gKeynameEngine $gKeynameInstaller $gFlavourPlatform);
use SDB::Install::MsgLst;
use SDB::Install::SysVars qw($currentPlatformName);
use LCM::Configuration::PersistenceUpdateManager;
use LCM::FileUtils qw(MyRealPath);
use File::Basename;
use File::Spec;

sub new {
    my $class = shift();
    my $self = $class->SUPER::new(@_);

    $self->defineParameters();
    $self->addListeners();
    $self->setPersistenceManager(LCM::Configuration::PersistenceUpdateManager->new($self));

    return $self;
}

sub defineParameters {
    my ($self) = @_;
    my $order = 1;

    $self->{params} = {
        'SID'                       => $self->getParamSID($order++, $ini_section_server, 1),
        'DvdPath'                   => GetParamDvdPath($order++, $ini_section_general, $self->getFlavourProductName()),
        'ComponentDirs'             => GetParamComponentDirs($order++, $ini_section_general),
        'ComponentFsRoot'           => GetParamComponentFsRoot($order++, $ini_section_general, 1),
        'VerifySignature'           => GetParamVerifySignature($order++, $ini_section_general),
        'RemoteExecution'           => $self->getParamRemoteExecution($order++, $ini_section_general, 0),
        'ExternalExecutablePath'    => $self->getParamExternalExecutablePath($order++, $ini_section_general), # for internal use only
    };

    $self->setHidden('SID', 1);
    $self->setInteractive('SID', 0);
}

sub InitDefaults {
    my $self = shift();
# current_sid is needed  for the sake of persistency_manager->getPersistenceFilename()
    my $sid = $self->{current_sid} = LCM::Installer->new()->getSid();

    $self->setDefault('SID', $sid, 1);
    $self->setDefault('VerifySignature', 1, 1);

# The resident installer must not print the detected components
# The non-resident one will print them after we delegate the execution to it
    $self->detectInstalledComponents($sid);

    return 1;
}

sub CheckParams {
    my ($self, $isBatchMode) = @_;
    $self->_handlePersistence();
    return $self->SUPER::CheckParams($isBatchMode);
}

sub _handlePersistence {
    my ($self) = @_;
    if ($self->getIgnore('check_pending_upgrade')) {
        $self->getMsgLst()->addMessage("Ignoring persisted values due to --ignore command line switch.");
        return 1;
    }

    if (!$self->pers_exists()) {
        return 1;
    }

    for my $paramId ('DvdPath', 'ComponentDirs', 'ComponentFsRoot', 'VerifySignature') {
        my $persistedValue = $self->getPersistedValue($paramId);
        if ($persistedValue) {
            $self->setDefault($paramId, $persistedValue, 1);
        }
    }
}

sub getComponentManager {
    my ($self) = @_;
    if (!defined($self->{componentManager})) {
        my $mcm = LCM::ComponentManager::UpdateSystemBootstrapComponentManager->new($self);
        $mcm->setMsgLstContext([$self->getMsgLst()]);
        $self->{componentManager} = $mcm;
    }
    return $self->{componentManager};
}

sub pers_filename {
    my ($self) = @_;
    return $self->getPersistenceManager()->getPersistenceFilename();
}

sub checkSID {
    my ($self, $value) = @_;
    my $systemSID = LCM::Installer->new()->getSid();
    if ($value ne $systemSID) {
        $self->setErrorMessage("Can't use SID '$value' for update of system '$systemSID'. If you want to update another system, use its own dedicated resident hdblcm.");
        return 0;
    }
    return 1;
}

sub getAction {
    return LCM::Configuration::GenericStackAny::UPDATE_ACTION;
}

sub getCustomLogSuffix {
    'resident';
}

sub getIgnoreValues{
    return LCM::Configuration::GenericStackUpdateConfiguration::getIgnoreValues();
}

sub addListeners {
    my ($self) = @_;
    my $scanner = LCM::ComponentManager::ComponentScanner->new($self->getComponentManager(),$self,0,0);

    $self->addParameterListener('ComponentDirs',            LCM::Configuration::ValueChangeListeners::Update::UpdateSystemBootstrapComponentListener->new($scanner, 'ComponentDirs'));
    $self->addParameterListener('DvdPath',                  LCM::Configuration::ValueChangeListeners::Update::UpdateSystemBootstrapComponentListener->new($scanner, 'DvdPath'));
    $self->addParameterListener('ComponentFsRoot',          LCM::Configuration::ValueChangeListeners::Update::UpdateSystemBootstrapComponentListener->new($scanner, 'ComponentFsRoot'));
    $self->addParameterListener('VerifySignature',          LCM::Configuration::ValueChangeListeners::Update::ServerDetectionListener->new());
    $self->addParameterListener('ExternalExecutablePath',   LCM::Configuration::ValueChangeListeners::SignatureVerificationListenerFactory::getSignatureVerificationListener());
}

sub getExternalExecutable {
    my ($self) = @_;
    my $appContext = LCM::App::ApplicationContext->getInstance();
    my $application = $appContext->getApplication();
    if (!defined($application)) {
        return undef;
    }
    return $application->isGUIApplication() ? 'hdblcmgui' : 'hdblcm';
}

sub getExternalHdblcmPath {
    my ($self) = @_;
    my $executableName = $self->getExternalExecutable();
    if (!$executableName) {
        $self->getErrMsgLst()->addError("Failed to determine the external hdblcm executable.");
        return undef;
    }

    my $installer = $self->getComponentManager()->getComponentByKeyName($gKeynameInstaller);
    my $executablePath = $installer ? File::Spec->catfile(dirname($installer->getPath()), $executableName) : undef;
    return $executablePath ? MyRealPath($executablePath) : undef;
}

sub getStaticDialogs {
    my ($self) = @_;
    require LCM::Gui::Dialogs::UpdateBootstrapParamsDialog;
    require LCM::Gui::Dialogs::BootstrapDelegationDialog;
    require LCM::Gui::Dialogs::ConfigurationExecutionDialog;
    my @dialogs = ('LCM::Gui::Dialogs::UpdateBootstrapParamsDialog',
            'LCM::Gui::Dialogs::BootstrapDelegationDialog',
            'LCM::Gui::Dialogs::ConfigurationExecutionDialog');
    my $curFlavour = $self->getComponentManager()->getHANAFlavour();
    if ( $curFlavour eq $gFlavourPlatform ) {
       push @dialogs, 'LCM::Gui::Dialogs::FinalizeDialog';
    } else {
       push @dialogs, 'LCM::Gui::Dialogs::FinalizeCockpitInstallationDialog';
    }
    return \@dialogs;
}

sub getConfigureDialogs {
    my ($self) = @_;
    return [];
}

sub getProductName {
    my ($self) = @_;
    my $flavourProductName = $self->getFlavourProductName();
    return "Bootstrap non-resident update of $flavourProductName System and Components";
}

sub getParamExternalExecutablePath {
    my ($self, $order, $section) = @_;
    return {
        'order'             => $order,
        'section'           => $section,
        'hidden'            => 1,
        'set_interactive'   => 0,
        'init_with_default' => 1,
    };
}

1;