package LCM::Configuration::ValueChangeListeners::ActionConfigurationSelectedSystemListener;

use strict;
use warnings;

use LCM::DevelopmentTrace;

use constant EXIT => "Exit (do nothing)";
use constant PENDING_INSTALL_PATTERN => "pending installation";
sub new {
    return bless({},shift);
}

sub onValueChange {
    my ($self, $value, $config) = @_;
    if ( $value eq "install" ) {
        $config->setValue( 'Action', 'install' );
    } elsif ( $value eq  EXIT) {
        LCM::DevelopmentTrace::RemoveTempDevelopmentTrace();
        exit;
    } elsif ( $value eq "extract_components") {
        $config->setValue('Action', 'extract_components');
    } elsif ( $value eq "print_detected_components") {
        $config->setValue('Action', 'print_detected_components');
    } else {
        if ( $value =~ PENDING_INSTALL_PATTERN ) {
            $config->setValue( 'Action', 'install' );
            $config->setPendingInstallation(1);
        } else {
            $config->setValue( 'Action', 'update' );
        }
        $self->{params}->{SelectedSystem}->{no_retry} = 1;
        my ($sid) = $value =~ /^(\w{3})/;
        $config->setValue( 'Action_SID', $sid );
    }
    return 1;
}

1;