package LCM::Configuration::ValueChangeListeners::AddHostRoles::XSUserIsolationListener;

use strict;
use parent 'LCM::Configuration::ValueChangeListeners::XSUserIsolationBase';
use SDB::Install::Globals qw($gHostRoleXS2Standby $gHostRoleXS2Worker);

# Override
sub _getHostsList {
    my ($self, $configuration) = @_;
    my $addHostRolesMap = $configuration->getValue('AddRoles') || {};
    my $result = [];

    for my $host (keys(%{$addHostRolesMap})){
        my $roles = [ split(',', $addHostRolesMap->{$host}) ];
        my $hasXsRole = grep { $_ eq $gHostRoleXS2Standby || $_ eq $gHostRoleXS2Worker } @{$roles};

        push(@{$result}, $host) if($hasXsRole);
    }
    return $result;
}

1;