package LCM::Configuration::ValueChangeListeners::Cockpit::CockpitSpaceListener;

use strict;
use SDB::Install::Globals qw($gShortProductNameXS2);


my $FAILED_XS_LOGIN_WARNING = "Failed to login into $gShortProductNameXS2. Database might be offline. ".
                              "If the specified space '%s' already exists, it will be used and won't be modified.".
                              "Make sure it is configured properly.";

my $SPACE_EXISTS_WARNING    = "The $gShortProductNameXS2 space '%s' already exists and it will not be modified. ".
                              "Make sure it is configured properly.";

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $cockpitSpace, $configuration) = @_;
    my $hasXSA      = $configuration->hasXSA();
    my $xsClient    = $hasXSA ? $configuration->getXSClient() : undef;
    my $xsLogged    = $xsClient ? $xsClient->login() : 0;
    my $spaceExists = $xsLogged ? $xsClient->spaceExists($cockpitSpace) : 0;
    my $isUpdate    = $configuration->isCockpitStackUpdate();

    if ($isUpdate && $xsLogged && !$spaceExists) {
# Update case where the xs login was successful and the space does not exist => we must blow up
        $configuration->setErrorMessage("Provided space '$cockpitSpace does not exist");
        return 0;
    }

    if ($hasXSA && !$xsLogged) {
        $configuration->addParameterWarning('CockpitXSSpace', sprintf($FAILED_XS_LOGIN_WARNING, $cockpitSpace));
    }

    if ($spaceExists) {
        my $spaceGUID = $xsClient->retrieveSpaceGUID($cockpitSpace);
        $configuration->setValue('CockpitSpaceGUID', $spaceGUID);

        $configuration->addParameterWarning('CockpitXSSpace', sprintf($SPACE_EXISTS_WARNING, $cockpitSpace)) if !$isUpdate;
    }

    $configuration->setSkip('CockpitTenant', $spaceExists);
    $xsClient->logout() if $xsLogged;
    return 1;
}

1;
