package LCM::Configuration::ValueChangeListeners::ComponentLocationListener;

use strict;
use SDB::Install::System qw(isAdmin);

sub new {
    my ($class) = @_;
    my $self = {};
    bless $self, $class;
    return $self;
}

sub onValueChange {
    my ($self, $value, $instconfig) = @_;

    if ( not defined $value ) {
        return 0;
    }

	# Can't detect if user is sidadm on this stage, there is validation after selection of SID
    my $isSidAdmUserExecution = isAdmin() ? 0 : 1;
	my $mediumCmpMgr = $instconfig->getComponentManager();
	$mediumCmpMgr->setSidAdmUserExecution($isSidAdmUserExecution) if defined $mediumCmpMgr;

    return 1;
}

1;
