package LCM::Configuration::ValueChangeListeners::ConvertToMultiDB::ImportContentListener;

use strict;
use SDB::Install::Globals qw($gProductNameEngine);
use SDB::Install::Configuration qw($bool_false_pattern $bool_true_pattern);

sub new { return bless({}, shift()); }

sub onValueChange {
	my ($self, $value, $configuration) = @_;
	my $shouldImportContent = ($value =~ /$bool_true_pattern/);
	my $shouldStartDb = !$configuration->isSkipped('NoStart') && $configuration->getValue('NoStart') =~ /$bool_false_pattern/;
	my $shouldStartTenantDb = !$configuration->isSkipped('NoStartTenantDB') && $configuration->getValue('NoStartTenantDB') =~ /$bool_false_pattern/;

	if(!$shouldStartDb && $shouldImportContent){
		$configuration->getErrMsgLst()->addError("Cannot import delivery units if the $gProductNameEngine is not started");
		return undef;
	}
	if(!$shouldStartDb && $shouldStartTenantDb){
		$configuration->getErrMsgLst()->addError("Cannot start the tenant database if the $gProductNameEngine is not started");
		return undef;
	}
	return 1;
}

1;