package LCM::Configuration::ValueChangeListeners::ConvertToMultiDB::NoStartTenantDbListener;

use strict;
use SDB::Install::Globals qw($gProductNameEngine);
use SDB::Install::Configuration qw($bool_false_pattern $bool_true_pattern);

sub new { return bless({}, shift()); }

sub onValueChange {
	my ($self, $value, $configuration) = @_;
	my $shouldStartTenantDb = ($value =~ /$bool_false_pattern/);
	my $shouldStartDb = !$configuration->isSkipped('NoStart') && $configuration->getValue('NoStart') =~ /$bool_false_pattern/;
	my $shouldImportContent = !$configuration->isSkipped('ImportContent') && $configuration->getValue('ImportContent') =~ /$bool_true_pattern/;

	if(!$shouldStartTenantDb && $configuration->hasXSA()) {
		my $message = "The system has installed XSA, which will reside in the tenant database after conversion. ".
					  "Therefore, it's not possible to convert the system without starting the tenant database.";
		$configuration->getErrMsgLst()->addError($message);
		$configuration->setNoRetry('NoStartTenantDb');
		return 0;
	}

	if(!$shouldStartDb && $shouldImportContent){
		$configuration->getErrMsgLst()->addError("Cannot import delivery units if the $gProductNameEngine is not started");
		return undef;
	}

	if(!$shouldStartDb && $shouldStartTenantDb){
		$configuration->getErrMsgLst()->addError("Cannot start the tenant database if the $gProductNameEngine is not started");
		return undef;
	}

	return 1;
}

1;