package LCM::Configuration::ValueChangeListeners::DownloadComponents::PersistWebServiceURLListener;

use strict;
use SDB::Install::MsgLst;

sub new {
    return bless({}, shift());
}

sub onValueChange {
    my ($self, $value, $configuration) = @_;
    my $sapSystem = $configuration->getSAPSystem();
    my $filePath = $sapSystem->getUserConfigFile();
    my $saveContext = $sapSystem->getMsgLstContext();

    $sapSystem->setMsgLstContext([new SDB::Install::MsgLst(), new SDB::Install::MsgLst()]);
    if(!$sapSystem->saveConfig({ web_service_proxy_url => $value })){
        $configuration->getMsgLst()->AddWarning("Cannot update user config '$filePath'");
    }
    $sapSystem->setMsgLstContext($saveContext);
    return 1;
}

1;