package LCM::Configuration::ValueChangeListeners::Install::AdditionalHostsListener;

use strict;
use LCM::Component;
use SDB::Install::Globals qw ($gSpecificHostsRolesRegex);

sub new { return bless({}, $_[0]); }

sub onValueChange {
	my ($self, $value, $instconfig) = @_;

	$instconfig->initRecommendationTexts();
	$instconfig->setSkip('AutoAddXS2Roles', $instconfig->_shouldSkipAutoAddXS2Roles());

    if ($instconfig->isOptimizedExecution()) {
        # HDBLCM must add all hosts, including the DB ones
        $instconfig->setAddHostsFilterRegex('.+');
    } else {
        # HDBCLCM must add only the sepcific hosts, the DB hosts will be added by hdbinst
        $instconfig->setAddHostsFilterRegex($gSpecificHostsRolesRegex);
    }

	return 1;
}

1;
