package LCM::Configuration::ValueChangeListeners::Install::DetectCustomConfigDir;
use warnings;
use strict;

use File::Basename qw(dirname);
use File::Spec;
use File::stat;
use SDB::Install::Globals qw($gKeynameEngine $gProductNameEngine);

sub new {
	return bless({}, shift);
}

sub onValueChange {
	my (undef, undef, $configuration) = @_;
	my $componentManager = $configuration->getComponentManager();
	if (!defined $componentManager) {
		$configuration->getErrMsgLst()->addError("Failed to get Component Manager.");
		return undef;
	}

	my $serverComponent  = $componentManager->getComponentByKeyName($gKeynameEngine);
	if (!defined $serverComponent) {
		$configuration->getErrMsgLst()->addError("Failed to detect selected '$gProductNameEngine'.");
		return undef;
	}

	my $installerDir = $serverComponent->getInstallerDir();
	if (!defined $installerDir) {
		$configuration->getErrMsgLst()->addError("Failed to detect manifest path of '$gProductNameEngine'.");
		return undef;
	}

	my $customConfigDir = File::Spec->catfile($installerDir, 'configurations', 'custom');
	if (File::stat::stat($customConfigDir)) {
		$configuration->setDefault('CustomConfigDir', $customConfigDir, 1);
	}
	return 1;
}

1;