package LCM::Configuration::ValueChangeListeners::Install::RootUserListener;

use LCM::HostsParser qw ( ParseHostStringToMap );
use LCM::SapHostAgentFunctions;

sub new {
	my ($class) = @_;

	my $self = {};
	bless $self, $class;

	return $self;
}

sub onValueChange {
	my ($self, $value, $instconfig) = @_;

	$instconfig->checkSslCiphersConfig();
	my $intallHostagent = $instconfig->getValue( "InstallHostagent" );
	if ( $intallHostagent ) {
		return 1;
	}
	
	my $isSHAInstalledOnAllRemoteHosts = $self->_isSHAInstalledOnAllRemoteHosts( $instconfig );
	
	$shaHelper = new LCM::SapHostAgentFunctions(undef);
	my $isSHAInstalledOnLocalHost = $shaHelper->isHostagentInstalled();
	
	if ( ! $isSHAInstalledOnAllRemoteHosts or ! $isSHAInstalledOnLocalHost ) {
		$instconfig->setSkip( "CertificatesHostmap", 1 );
		$instconfig->setSkip( "HostagentPassword", 1 );
		$instconfig->setValue('DeploySHAConfigurations', 0);
	}
	
	return 1;
}

sub _isSHAInstalledOnAllRemoteHosts {
	my ($self, $instconfig) = @_;
	
	my @remoteHostsWithInstalledSHA =  keys %{$instconfig->{remoteSaphostagents}};
	
	my $addHosts =  $instconfig->getValue("AddHosts");
	my @remoteHosts = keys % { ParseHostStringToMap( $addHosts ) };
	
	my @remoteHostsWithoutInstalledSHA = grep { $_ !~ @remoteHostsWithInstalledSHA } @remoteHosts;
	
	return ( scalar @remoteHostsWithoutInstalledSHA == 0 ) ? 1 : 0;
}
1;