package LCM::Configuration::ValueChangeListeners::Install::UseMasterPasswordListener;

use strict;
use SDB::Install::Configuration qw($bool_true_pattern);

sub new {
	return bless({}, shift());
}

sub onValueChange {
	my ($self, $value, $config) = @_;
	my $shallSkipMasterPassword = ($value =~ /$bool_true_pattern/) ? 0 : 1;

	$config->setSkip('MasterPassword', $shallSkipMasterPassword);
	$self->_hideNeededPasswordParams($config) if !$shallSkipMasterPassword;
	return 1;
}

sub _hideNeededPasswordParams {
	my ($self, $config) = @_;

	my $passwordsToHide = $config->_getPasswordIdsForMasterPassword();
	for my $parameterId (@$passwordsToHide){
		$config->setHidden($parameterId, 1);
	}
}

1;
