package LCM::Configuration::ValueChangeListeners::InstallUpdate::LocalSecureStoreListener;

use strict;
use SDB::Install::Globals qw($gKeynameEngine $gProductNameEngine $gProductNameLSS $gKeynameLSS);
use LCM::SignatureFileChecker qw($MESSAGE_ERROR_MISSING_FILE $MESSAGE_SAP_NOTE);

my $SAP_NOTE_REPAIR_INSTALLATION = "See SAP note 2078425, section 'Repairing installations with missing signature' for instructions how to repair an installed system with missing signature.";

sub new { return bless({}, shift()); }

sub onValueChange {
    my ($self, $value, $config) = @_;
    my $ignoreSignatureCheck = $config->getSystemUsage() =~ /development|custom/ ? 1 : 0;
    return 1 if($ignoreSignatureCheck || $self->isServerSigned($config));

    my $isSupported = $config->getFeatureManager()->isLssTrustUnsignedServerSupported();
    my $option = $config->getOpt('LSSTrustUnsignedServer');
    if ($value && !$isSupported) {
        $config->setErrorMessage("The option '$option' is not supported for the current version of $gProductNameLSS. Use newer version of $gProductNameLSS.");
        return 0;
    }

    my $isServerSelected = $self->isServerSelected($config);
    my $sapNoteInfo = $isServerSelected ? "$MESSAGE_ERROR_MISSING_FILE $MESSAGE_SAP_NOTE" : $SAP_NOTE_REPAIR_INSTALLATION;

    my $errorMsg = "$gProductNameLSS requires that the $gProductNameEngine component has valid signature and there is no such signature in the installation kit. $sapNoteInfo\n";
    if($isSupported){
        $errorMsg.= "To trust the SAP HANA Database component without signature use the option $option.";
    }

    my $rc = 0;
    $config->setErrorMessage($errorMsg);
    if($value){
        $config->getMsgLst()->addMessage("Ignoring error due to command line switch '$option'");
        $rc = 1;
    }
    return $rc;
}

sub isServerSigned {
    my ($self, $config) = @_;
    my $isServerSelected = $self->isServerSelected($config);
    my $compManager = $isServerSelected ? $config->getComponentManager() : $config->getSystemComponentManager();

    my $server = $compManager->getComponentByKeyName($gKeynameEngine);
    my $isSigned = defined $server->getSignature() ? 1 : 0;
    return $isSigned;
}

sub isServerSelected {
    my ($self, $config) = @_;
    my $compManager = $config->getComponentManager();
    return $compManager->isHDBServerComponentSelected();
}

1;
